/*
 *	Filnamn:		CPulDate.cpp
 *	Syfte  :		Funktioner och classer fr att hantera datum
 *
 *	Historik		
 *	961219, UL		Skapad
 *	970223, PK		Lagt till GetAsLong(), SetFromLong()
 *	970301, PK		Lagt till CPulDateDb.operator==
 *	970511, PK		Lagt till GetDate2()
 *	970826, UL		Rttat fel i SetCentury (hoppar ver blankt datum)
 *	970831, PK		Lagt till <, <=, > och >= i CPulDateDb
 *	970831, PK		Rttat fel i += och -=, tog alltid += 1 eller -= 1 samt
 *					gjort klart - som ej var frdiggjord
 *	970831, PK		Lagt till hantering av Julianskt datumformat
 *	980610, PK		Lagt till GetDate6()
 *	980928, PK		Rttat fel i operator-, returnerat vrde var +1 fr hgt
 *	1998-11-29	PK		Lagt till !=
 *	1998-12-15	Magnus	ndrat s att SetMonth ven stter rtt dag(anv. eg. ej.)
 *	1999-02-28	Peter	Lagt till ngra funktioner samt ndrat s att Add... returnerar this
 *	1999-03-08	Peter	ndrat returvrde p SetCentury() till CPulDateDb& samt rttat SetDate() s att 
 *						alltid ven sekel stts
 *	1999-03-08	Peter	ndrat namn p Valid till IsValid()
 *	1999-04-11	Peter	Lgt till funktioner fr hantering av veckonr
 *	1999-06-19	Magnus	Tagit bort kontrollen p IsValid p SetLastDayOfMonth()
 *	1999-06-26	Peter	Lagt till GetMonth4(), GetYear() och GetMonthStr() fr CPulMonthDb
 *	1999-07-04	Peter	Lagt till CPulMonthDb::operator-
 *	1999-09-18	Peter	Lagt till CPulDateDb::GetDayStr
 *	1999-11-03	Peter	Tagit bort felkontroll IsValid() i AddYear och AddMonth d AddMonth inte
 *						fungerade ver rsskiftet
 *	1999-11-23	Magnus	Tagit bort felkontroll IsValid()(p CPulMonth) i AddYear och AddMonth d AddMonth inte
 *						fungerade ver rsskiftet 
 *	2000-02-24	Ulf		Typekonvertering CPulDate = CTime
 *	2001-09-24	Peter	Lagt till ytterligare startdatum fr vecka 1, r 2002-2010
 *	2003-01-17	Johan G Rttat funktionen AddMonth() s att man kan backa flera mnader bakt ver rsskiften
 *	2003-11-25	Malin	Lagt till CPulDateDb::SameMonth(CString sDate), kontrollerar om sDate r datum i samma r, mnad.
 *	2005-02-24	Ulf		Lagt till CPulDate2 och CPulMonth2
 *	2005-06-01	JohanG	ndrat i CPulDate2::operator!=
 *	2005-09-06	David	Lagt till GetFirstDayOfMonth fr CPulDateDb
 *	2005-11-05	Peter	Lagt till specialhantering av CPulMonth fr ackmulerade perioder och kvartal
 *	2005-12-20	Peter	Rttat fel i GetWeekNr() nr vecka 52 strcker sig in p nstfljande r
 *	2006-04-02	Peter	Lagt till specialhantering av CPulMonth.GetMonth fr ackumulerade perioder
 *	2006-07-01	Peter	Lagt till CPulMonthDb::GetPeriod()
 *	2007-02-06	Peter	Lagt till CPulDateDb::GetToday() fr f dagens datum utan att behva ha en instans av CPulDateDb
 */
#include "stdafx.h"
#include "time.h"
//#include "UsefulFuncs.h"
//#include "PulDateTime.h"
#include "PulDate.h"
//#include "PulPeriod.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/********************************************************************************/
/*																				*/
/*	CPulDate2																	*/
/*																				*/
/********************************************************************************/
CPulDate2::CPulDate2(int Year, int Month, int Day)
{
	Init();
	SetDateTime(Year, Month, Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	IsValid();
}

CPulDate2::operator CPulDate() {
	return CPulDate(GetYear(), GetMonth(), GetDay());
}

/*CPulDate2::operator CPulDateDb() {
	CPulDateDb	d;
	d.Init();
	d.m_dwDate.Year = year;
	d.m_dwDate.Month = (BYTE)month;
	d.m_dwDate.Day = (BYTE)day;
	return d;
}*/

int	CPulDate2::operator==(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (d1.IsEmpty() && IsEmpty())
		return TRUE;
	if (d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this == d; 
}

int	CPulDate2::operator!=(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (!d1.IsEmpty() && d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	if (!d1.IsEmpty())
		d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this != d; 
}

int	CPulDate2::operator<(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (!d1.IsEmpty() && d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	if (!d1.IsEmpty())
		d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this < d; 
}

int	CPulDate2::operator<=(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (!d1.IsEmpty() && d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	if (!d1.IsEmpty())
		d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this <= d; 
}

int	CPulDate2::operator>(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (!d1.IsEmpty() && d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	if (!d1.IsEmpty())
		d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this > d;
}

int	CPulDate2::operator>=(const CPulDateDb &date2)	
{ 
	CPulDateDb	d1 = date2;
	if (!d1.IsEmpty() && d1.m_dwDate.Year < 100)
		d1.SetCentury();
	CPulDate2	d;
	d.Init();
	if (!d1.IsEmpty())
		d.SetDateTime(d1.m_dwDate.Year, d1.m_dwDate.Month, d1.m_dwDate.Day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	return *this >= d; 
}

/*long	CPulDate2::operator-(const CPulDateDb& Date)	
{ 
	CPulDate2	d;
	d.Init();
	((COleDateTime)d).SetDate(date2.m_dwDate.Year, date2.m_dwDate.Month, date2.m_dwDate.Day);
	return *this - d; 
}*/


/////////////////////////////////////////////////////////////////////////////
// CPulDate2::Valid
//
//	Kontrollerar om det r ett korrekt datum
//
//	Returvrde:
//		Returnerar TRUE om det r korrekt annars FALSE
//
//	Anmrkning:
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
BOOL	CPulDate2::IsValid()
{
	if (GetStatus() == COleDateTime::invalid || GetStatus() == COleDateTime::error)
		return FALSE;

	CString	date = GetDate();

	if (date.IsEmpty()) {
		SetStatus(COleDateTime::valid);
		return TRUE;
	}

	TIMESTAMP_STRUCT tsDate;
	tsDate.year = GetYear();
	tsDate.month = GetMonth();
	tsDate.day = GetDay();
	tsDate.hour = GetHour();
	tsDate.minute = GetMinute();
	tsDate.second = GetSecond();
	tsDate.fraction = 0;
	int			lyr = 0;

	if (tsDate.year < 100) {
		if (tsDate.year < 50)
			tsDate.year += 2000;
		else
			tsDate.year += 1900;
	}
	if (tsDate.year < 1000)
		tsDate.year += 2000;
	if (tsDate.month < 1 || tsDate.month > 12) {
		SetStatus(COleDateTime::invalid);
		return FALSE;
	}
	if(tsDate.day < 1 || tsDate.day > 31) {
		SetStatus(COleDateTime::invalid);
		return FALSE;
	}
	if (tsDate.day > 30 && (tsDate.month == 4 || tsDate.month == 6 || tsDate.month == 9 || tsDate.month == 11)) {
		SetStatus(COleDateTime::invalid);
		return FALSE;
	}
	if (tsDate.month == 2 && tsDate.day > 28) {
		if (tsDate.year == (4*(tsDate.year/4)))
			lyr = 1;
		if (tsDate.year == (100*(tsDate.year/100)))
			lyr = 0;
		if (tsDate.year == (400*(tsDate.year/400)))
			lyr = 1;
		if (!lyr) {
			SetStatus(COleDateTime::invalid);
			return FALSE;
		}
		else {
			if (tsDate.day > 29) {
				SetStatus(COleDateTime::invalid);
				return FALSE;
			}
		}
	}

	SetStatus(COleDateTime::valid);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::GetDate
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt
//
CString	CPulDate2::GetDate()
{
	CString	str;

	str.Format("%04d%02d%02d", GetYear(), GetMonth(), GetDay());

	if (IsEmpty())
		str.Empty();

	return str;
}

// CPulDate2::GetDate2
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt med - mellan delarna
//
CString	CPulDate2::GetDate2()
{
	CString	str;

	str.Format("%04d-%02d-%02d", GetYear(), GetMonth(), GetDay());

	if (IsEmpty())
		str.Empty();

	return str;
}

// CPulDate2::GetDate2
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt enligt format MMDD
//
CString	CPulDate2::GetDate6()
{
	CString	str;

	str.Format("%02d%02d%02d", GetYear() % 100, GetMonth(), GetDay());

	if (IsEmpty())
		str.Empty();

	return str;
}

void	CPulDate2::Init()
{
	SetDateTime(MC_DATETIME_YEAR_INIT, 
				MC_DATETIME_MONTH_INIT, 
				MC_DATETIME_DAY_INIT, 
				MC_DATETIME_HOUR_INIT, 
				MC_DATETIME_MINUTE_INIT, 
				MC_DATETIME_SECOND_INIT);
	SetStatus(COleDateTime::valid);
}

bool	CPulDate2::IsEmpty()
{
	return	GetStatus() == COleDateTime::null ||
			(GetYear() == MC_DATETIME_YEAR_INIT && 
			GetMonth() == MC_DATETIME_MONTH_INIT && 
			GetDay() == MC_DATETIME_DAY_INIT);
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::SetDate
//
//	Stter aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt
//
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&	CPulDate2::SetDate(CString Date)
{
	int year;
	int month;
	int day;
	Init();
	if (Date.GetLength() == 10) {		// -MM-DD
		year = atoi(Date.Mid(0,4));
		month = atoi(Date.Mid(5,2)); 
		day = atoi(Date.Mid(8,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT) ||
		    (day != 0 && day != MC_DATETIME_DAY_INIT))
			SetDateTime(year, month, day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	}
	else if (Date.GetLength() == 8) {	// MMDD
		year = atoi(Date.Mid(0,4));
		month = atoi(Date.Mid(4,2)); 
		day = atoi(Date.Mid(6,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT) ||
		    (day != 0 && day != MC_DATETIME_DAY_INIT))
			SetDateTime(year, month, day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	}
	else if (Date.GetLength() == 6) {	// MMDD
		year = atoi(Date.Mid(0,2));
		if (year < 50)
			year += 2000;
		else
			year += 1900;
		month = atoi(Date.Mid(2,2)); 
		day = atoi(Date.Mid(4,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT) ||
		    (day != 0 && day != MC_DATETIME_DAY_INIT))
			SetDateTime(year, month, day, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
	}
	else if (Date.Mid(0,1) == 'D')		// Initiera till dagens datum
		SetToday();
	else if (Date.Mid(0,1) == 'G') {	// Initiera till grdagens datum
		SetToday();
		(*this)--;
	}
	else if (Date.Mid(0,1) == 'M') {	// Initiera till morgondagens datum
		SetToday();
		(*this)++;
	}
	IsValid();	// Stter rtt status
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::SetToday
//
//	Stter aktuellt datum till dagens datum
//
//	Returvrde:
//		Returnerar dagens datum som ett CPulDate2-objekt
//
CPulDate2&	CPulDate2::SetToday()
{
	*((COleDateTime*)this) = COleDateTime::GetCurrentTime();
	return *this;
/*
	struct tm	*today;
	time_t		ltime;
	char		date[9];
	CString		str;

	time(&ltime);
	today = localtime(&ltime);
	strftime(date, 9, "%Y%m%d", today);
	str.Format("%s", date);
	return SetDate(str);*/
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::SetLastDayOfMonth
//
//	Stter aktuellt datum sista dagen i mnaden
//
//	Returvrde:
//		Returnerar sista dagen i mnaden som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&	CPulDate2::SetLastDayOfMonth()
{
	CString	str = GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);

	str.Format("%04d%02d%02d", GetYear(), GetMonth(), 28);
	SetDate(str);
//	day = 28;
	unsigned short	Month = GetMonth();
	(*this)++;
	while(GetMonth() == Month) {
		Month = GetMonth();
		(*this)++;
	}
	(*this)--;
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::AddYear
//
//	Adderar r i aktuellt datum med ett angivet antal r
//
//	Indata:
//		Years			Antal r som r i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&	CPulDate2::AddYear(int Years)
{
	CPulDate2	dt(GetYear()+Years, GetMonth(), GetDay());
	if (dt.IsValid()) {
		SetDateTime(dt.GetYear(), 
					dt.GetMonth(), 
					dt.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
		IsValid();	// Stter rtt status
	}
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::AddMonth
//
//	Adderar Mnad i aktuellt datum med ett angivet antal mnader
//
//	Indata:
//		Months			Antal mnader som Mnad i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&	CPulDate2::AddMonth(int Months)
{
	COleDateTimeSpan	ts(1, 0, 0, 0);
	int	nCurrentMonth = GetMonth();
	int	nCurrentDay = GetDay();

	if (Months > 0) {
		while(GetMonth() == nCurrentMonth)
			*this += ts;
		nCurrentMonth = GetMonth();
		while(GetDay() < nCurrentDay && GetMonth() == nCurrentMonth)
			*this += ts;
		if (GetMonth() != nCurrentMonth)
			*this -= ts;	// Backar ett steg t ex om man stod p den 31:e s kommer man att hamna p den 30:e i nsta mnad
	}
	else if (Months < 0) {
		while(GetMonth() == nCurrentMonth)
			*this -= ts;
		while(GetDay() > nCurrentDay)
			*this -= ts;
	}
	return *this;
}


/*
 *	Funktionen tar fram ett datum ett antal veckor och dagar fram i tiden.
 *
 *	Indata :
 *		*datum		Startdatum.
 *		veckor		Antalet veckor framt i tiden.
 *		dagar		Antaler dagar efter antalet veckor framt
 *				i tiden.
 *
 *	Utdata :
 *		*dest		Area dr det framtagna datumet lggs.
 */
CPulDate2&	CPulDate2::AddWeeksAndDays(int nVeckor, int nDagar)
{
	SetFromJulianDate(ToJulianDate() + (nVeckor * 7) + nDagar);
	return *this;
} // CPulDate2::AddWeeksAndDays

/////////////////////////////////////////////////////////////////////////////
// CPulDate::AddDay
//
//	Adderar Dag i aktuellt datum med ett angivet antal dagar
//
//	Indata:
//		Days			Antal dagar som Dag i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&	CPulDate2::AddDay(int Days)
{
	COleDateTimeSpan	ts((Days>0?Days:(Days<0?Days*-1:0)), 0, 0, 0);
	if (Days > 0)
		*((COleDateTime*)this) += ts;
	else if (Days < 0)
		*((COleDateTime*)this) -= ts;
	return *this;
}

/*
 *	1998-07-29	Ulf
 *	Tar reda p vilken veckodag det r
 *
 *	Returvrde:
 *		Returnerar aktuell veckodag 1=Sndag, 2=Mndag, ... 7=Lrdag
 */
int	CPulDate2::DayOfWeek()
{
	return GetDayOfWeek();
}


CString	CPulDate2::GetDayStr(int nDayno)
{
	switch (nDayno == 0 ? DayOfWeek() : nDayno) {
	case 1 :
		return "Sndag";
		break;
	case 2 :
		return "Mndag";
		break;
	case 3 :
		return "Tisdag";
		break;
	case 4 :
		return "Onsdag";
		break;
	case 5 :
		return "Torsdag";
		break;
	case 6 :
		return "Fredag";
		break;
	case 7 :
		return "Lrdag";
		break;
	}
	return "";	// Ska inte intrffa
} // CPulDate2::GetDayName


CPulDate2	&CPulDate2::SetFirstMondayOfYear(int Year)
{
	switch (Year) {
	case 85 :
	case 1985 :	return SetDate("19841231");
	case 86 :
	case 1986 :	return SetDate("19851230");
	case 87 :
	case 1987 :	return SetDate("19870104");
	case 88 :
	case 1988 :	return SetDate("19880103");
	case 89 :
	case 1989 :	return SetDate("19890102");
	case 90 :
	case 1990 :	return SetDate("19900101");
	case 91 :
	case 1991 :	return SetDate("19901231");
	case 92 :
	case 1992 :	return SetDate("19911230");
	case 93 :
	case 1993 :	return SetDate("19930104");
	case 94 :
	case 1994 :	return SetDate("19940103");
	case 95 :
	case 1995 :	return SetDate("19950102");
	case 96 :
	case 1996 :	return SetDate("19960101");
	case 97 :
	case 1997 :	return SetDate("19961230");
	case 98 :
	case 1998 :	return SetDate("19971229");
	case 99 :
	case 1999 :	return SetDate("19990104");
	case 00 :
	case 2000 :	return SetDate("20000103");
	case 01 :
	case 2001 :	return SetDate("20010101");
	case 02 :
	case 2002 :	return SetDate("20011231");
	case 03 :
	case 2003 :	return SetDate("20021230");
	case 04 :
	case 2004 :	return SetDate("20031229");
	case 05 :
	case 2005 :	return SetDate("20050103");
	case 06 :
	case 2006 :	return SetDate("20060102");
	case 07 :
	case 2007 :	return SetDate("20070101");
	case 8 :
	case 2008 :	return SetDate("20071231");
	case 9 :
	case 2009 :	return SetDate("20081229");
	case 10 :
	case 2010 :	return SetDate("20100104");
	}
	return *this;
}

/*
 *	Stter aktuell dag till frsta dagen (mndag) i begrd vecka utifrn r och veckonr
 */
	CPulDate2	&CPulDate2::SetDate(int Year, int weeknr)
{
	SetFirstMondayOfYear(Year);
	return SetFromJulianDate(ToJulianDate() + (weeknr-1) * 7);
}


/*
 * 	Veckonumrering
 *	--------------
 *
 *	r 1972 faststlldes svensk standard fr veckonumrering
 *	(SIS 0102 12) och fr datumskrivning (SIS 0102 11). Fr.o.m.
 *	1973 tillmpar vi SIS-standarden fr veckonumrering. Denna
 *	innebr att ett veckonummer alltid svarar mot 7 dagar, och att
 *	vecka 1 r den frsta vecka som innehller 4 dagar eller mer av
 *	det nya ret. Mndagen betraktas som veckans frsta dag.
 *	SIS-standarden fr datumskrivning innebr, att d datum an-
 *	gives uteslutande med siffror, skall det skrivas i ordningen:
 *	r-mnad-dag, t.ex. 1990-02-28.
 */

/*
 *	Hmtar veckonummer frn aktuellt datum
 */
int		CPulDate2::GetWeekNr()
{
	CPulDate2	start;
	start.SetFirstMondayOfYear(GetYear());
	if (ToJulianDate() < start.ToJulianDate())		// ret brjar med v 53 fregende r
		return 53;
	else
		return 1 + (ToJulianDate() - start.ToJulianDate()) / 7;
}

/////////////////////////////////////////////////////////////////////////////
//
//	Konvertering till och frn Julianskt datumsystem
//	Koden kopierad frn Vitamin C
//
//	Konvertering till Julianskt datumformat
//
long	CPulDate2::ToJulianDate()
{
	long	ctmp, dtmp, mtmp, ytmp;
	long	result1, result2, result3;

	if (GetMonth() > 2) {
		mtmp = GetMonth() - 3;
		ytmp = GetYear();
	}
	else {
		mtmp = GetMonth() + 9;
		ytmp = GetYear() - 1;
	}
	ctmp	= ytmp / 100;
	dtmp	= ytmp - (100 * ctmp);
	result1 = 146097L * ctmp / 4;
	result2 = (1461 * dtmp) / 4;
	result3	= (153 * mtmp + 2) / 5;
	return result1 + GetDay() + result2 + 1721119L + result3;
} // CPulDate2::ToJulianDate

//
//	Konvertering frn Julianskt datumformat
//
CPulDate2	&CPulDate2::SetFromJulianDate(long lJulian)
{
	long	yr, mo, da, mtmp;
	mtmp	= lJulian - 1721119L;
	yr		= (4 * mtmp - 1) / 146097L;
	mtmp	= 4 * mtmp - 1- 146097L * yr;
	da		= mtmp / 4;
	mtmp	= ( 4 * da + 3) / 1461;
	da		= 4 * da + 3 - 1461 * mtmp;
	da		= (da + 4) / 4;
	mo		= (5 * da - 3) / 153;
	da		= 5 * da - 3 - 153 * mo;
	da		= (da + 5) / 5;
	yr		= 100 * yr + mtmp;
	if (mo < 10)
		mo += 3;
	else {
		mo -= 9;
		yr++;
	}
	Init();
	SetDateTime(yr, 
				mo, 
				da, 
				MC_DATETIME_HOUR_INIT, 
				MC_DATETIME_MINUTE_INIT, 
				MC_DATETIME_SECOND_INIT);
	IsValid();	// Stter rtt status
	return *this;
} // CPulDate2::SetFromJulianDate



/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(CPulDate2)
//
//	Operatorverlagring av = frn CPulDate2-objekt till CPulDate2-objekt
//	CPulDate2 = CPulDate2
//
//	Indata:
//		Date			Hger delens CPulDate2-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = CPulDate2);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulDate2&		CPulDate2::operator=(const CPulDate2 Date)
{
	if (Date.GetStatus() == COleDateTime::null) {
		Init();
		return *this;
	}

	CPulDate2	d;
	d.Init();
	d.SetDateTime(	Date.GetYear(), 
					Date.GetMonth(), 
					Date.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);

	if (!d.IsValid())
		return *this;

	Init();
	CString	str = d.GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);
	else {
		Init();
		SetDateTime(d.GetYear(), 
					d.GetMonth(), 
					d.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
		IsValid();	// Stter rtt status
	}

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(CPulDate2)
//
//	Operatorverlagring av = frn CPulDate2-objekt till CPulDate2-objekt
//	CPulDate2 = CPulDate2
//
//	Indata:
//		Date			Hger delens CPulDate2-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = CPulDate2);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulDate2&		CPulDate2::operator=(const CPulMonth2 Month)
{
	if (Month.GetStatus() == COleDateTime::null) {
		Init();
		return *this;
	}

	CPulDate2	d;
	d.Init();
	d.SetDateTime(	Month.GetYear(), 
					((COleDateTime)Month).GetMonth(), 
					Month.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);

	if (!d.IsValid())
		return *this;

	Init();
	CString	str = d.GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);
	else {
		Init();
		SetDateTime(d.GetYear(), 
					d.GetMonth(), 
					d.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
		IsValid();	// Stter rtt status
	}

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(CPulDate2)
//
//	Operatorverlagring av = frn CPulDate2-objekt till CPulDate2-objekt
//	CPulDate2 = CPulDate2
//
//	Indata:
//		Date			Hger delens CPulDate2-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = CPulDate2);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulDate2&		CPulDate2::operator=(const CPulDateDb Date)
{
	CPulDateDb d1 = Date;
	if (d1.IsEmpty()) {
		Init();
		return *this;
	}
	if (d1.m_dwDate.Year < 100)
		d1.SetCentury();

	CPulDate2	d;
	d.Init();
	d.SetDateTime(	d1.m_dwDate.Year, 
					d1.m_dwDate.Month, 
					d1.m_dwDate.Day, 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);

	if (!d.IsValid())
		return *this;

	Init();
	CString	str = d.GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);
	else {
		Init();
		SetDateTime(d.GetYear(), 
					d.GetMonth(), 
					d.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
		IsValid();	// Stter rtt status
	}

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(CTime)
//
//	Operatorverlagring av = frn CTime-objekt till CPulDate2-objekt
//	CPulDate2 = CTime
//
//	Indata:
//		Date			Hger delens CTime-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = CTime);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulDate2&		CPulDate2::operator=(const CTime Date)
{
	Init();
	CString	str;
	str.Format("%04d-%02d-%02d", Date.GetYear(), Date.GetMonth(), Date.GetDay());
	SetDate(str);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(CString)
//
//	Operatorverlagring av = frn CString-objekt till CPulDate2-objekt
//	CPulDate2 = CString
//
//	Indata:
//		Date			Hger delens CString-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = CString);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator=(const CString Date)
{
	SetDate(Date);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator=(LPCSTR)
//
//	Operatorverlagring av = frn konstant strng till CPulDate2-objekt
//	CPulDate2 = "strng"
//
//	Indata:
//		lpszDate			Hger delens strng i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate2 = "strng");
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator=(LPCSTR lpszDate)
{
	CString	str;
	str = lpszDate;
	SetDate(str);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator++
//
//	Operatorverlagring av ++CPulDate2
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return ++CPulDate2;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator++()
{
	SetFromJulianDate(ToJulianDate() + 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator++(int i)
//
//	Operatorverlagring av CPulDate2++
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulDate2++;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator++(int)
{
	SetFromJulianDate(ToJulianDate() + 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator--
//
//	Operatorverlagring av --CPulDate2
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return --CPulDate2;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator--()
{
	SetFromJulianDate(ToJulianDate() - 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator--(int i)
//
//	Operatorverlagring av CPulDate2--
//
//	Returvrde:
//		Returnerar aktuellt CPulDate2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulDate2--;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate2&		CPulDate2::operator--(int)
{
	SetFromJulianDate(ToJulianDate() - 1);
	return *this;
}

/*
 *	Logiska jmfrelseoperatorer ==, <, <=, >, >=
 *
 *	Indata :
 *		date2		datum att jmfra med
 *
 *	Funktionsvrde :
 *		TRUE(1) om uppfyllt, annars FALSE(0)
 */
int	CPulDate2::operator==(const CPulDate2 &date2)
{
	CPulDate2	d;
	d.Init();
	d.SetDateTime(	date2.GetYear(), 
					date2.GetMonth(), 
					date2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	d.IsValid();

	return (IsEmpty() && d.IsEmpty()) ||
		GetDay() == d.GetDay() && 
		GetMonth() == d.GetMonth() && 
		GetYear() == d.GetYear();
}


int	CPulDate2::operator!=(const CPulDate2 &date2)
{
	CPulDate2	d;
	d.Init();
	d.SetDateTime(	date2.GetYear(), 
					date2.GetMonth(), 
					date2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	d.IsValid();

	return IsEmpty() && !d.IsEmpty() ||
		GetDay() != d.GetDay() || 
		GetMonth() != d.GetMonth() || 
		GetYear() != d.GetYear();
}

int	CPulDate2::operator<(const CPulDate2 &date2)
{
	CPulDate2	d;
	d.Init();
	d.SetDateTime(	date2.GetYear(), 
					date2.GetMonth(), 
					date2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	d.IsValid();

	if (IsEmpty() && d.GetStatus() == COleDateTime::valid)
		return TRUE;
	if (d.IsEmpty())
		return FALSE;
	if (GetYear() < d.GetYear())
		return TRUE;
	if (GetYear() > d.GetYear())
		return FALSE;
	// Samma rtal
	if (GetMonth() < d.GetMonth())
		return TRUE;
	if (GetMonth() > d.GetMonth())
		return FALSE;
	// Samma mnad
	return GetDay() < d.GetDay();
}

int	CPulDate2::operator<=(const CPulDate2 &date2)
{
	return *this < date2 || *this == date2;
}

int	CPulDate2::operator>(const CPulDate2 &date2)
{
	CPulDate2	d;
	d.Init();
	d.SetDateTime(	date2.GetYear(), 
					date2.GetMonth(), 
					date2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	d.IsValid();

	if (d.IsEmpty() && GetStatus() == COleDateTime::valid)
		return TRUE;
	if (IsEmpty())
		return FALSE;
	if (GetYear() > d.GetYear())
		return TRUE;
	if (GetYear() < d.GetYear())
		return FALSE;
	// Samma rtal
	if (GetMonth() > d.GetMonth())
		return TRUE;
	if (GetMonth() < d.GetMonth())
		return FALSE;
	// Samma mnad
	return GetDay() > d.GetDay();
}

int	CPulDate2::operator>=(const CPulDate2 &date2)
{
	return *this > date2 || *this == date2;
}


/////////////////////////////////////////////////////////////////////////////
// CPulDate2::operator-(CPulDate)
//
//	Operatorverlagring av - skillnaden mellan tv CPulDate2-objekt
//	CPulDate2-CPulDate2
//
//	Indata:
//		Date			Hger delens CPulDate2-objekt i subtraktionen
//
//	Returvrde:
//		Returnerar antal dagar som skiljer de tv datumen
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s returneras 0;
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
//	OBS!
//		Funktionen returnerar differansen, EJ antal dagar i intervall.
//
long		CPulDate2::operator-(const CPulDate2& Date)
{
	CPulDate2	d;
	d.Init();
	d.SetDateTime(	Date.GetYear(), 
					Date.GetMonth(), 
					Date.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	
	if (!d.IsValid() || IsEmpty() || d.IsEmpty())
		return 0;
	return ToJulianDate() - d.ToJulianDate();
}

/*
 *	Syfte:	Anger om inparameterns datum r ett datum i samma mnad (och r) som klassens datum.	
 *	
 *	Indata:	
 *		sDate	Datum 
 *
 *	Retur:
 *		true	Om datumen r datum i samma r och mnad
 *		false	Om datumen inte r datum i samma r och mnad
 */
bool CPulDate2::SameMonth(CString sDate)
{
	CPulDate2 date;
	date.SetDate(sDate);
	return GetYear() == date.GetYear() && GetMonth() == date.GetMonth();
}


/********************************************************************************/
/*																				*/
/*	CPulMonth2																	*/
/*																				*/
/********************************************************************************/

void	CPulMonth2::Init()
{	
	SetDateTime(MC_DATETIME_YEAR_INIT, 
				MC_DATETIME_MONTH_INIT, 
				MC_DATETIME_DAY_INIT, 
				MC_DATETIME_HOUR_INIT, 
				MC_DATETIME_MINUTE_INIT, 
				MC_DATETIME_SECOND_INIT); 
	SetStatus(COleDateTime::valid); 
};

/*
 *	Logiska jmfrelseoperatorer ==, <, <=, >, >=
 *
 *	Indata :
 *		month2		mnad att jmfra med
 *
 *	Funktionsvrde :
 *		TRUE(1) om uppfyllt, annars FALSE(0)
 */
int	CPulMonth2::operator==(const CPulMonth2 &month2)
{
	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	month2.GetYear(), 
					((COleDateTime)month2).GetMonth(), 
					month2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	m.IsValid();

	return (IsEmpty() && m.IsEmpty()) ||
		((COleDateTime*)this)->GetMonth() == ((COleDateTime)m).GetMonth() && 
		GetYear() == m.GetYear();
}


int	CPulMonth2::operator!=(const CPulMonth2 &month2)
{
	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	month2.GetYear(), 
					((COleDateTime)month2).GetMonth(), 
					month2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	m.IsValid();

	return (IsEmpty() && m.GetStatus() == COleDateTime::valid) ||
		(GetStatus() == COleDateTime::valid && m.IsEmpty()) ||
		((COleDateTime*)this)->GetMonth() != ((COleDateTime)m).GetMonth() || 
		GetYear() != m.GetYear();
}

int	CPulMonth2::operator<(const CPulMonth2 &month2)
{
	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	month2.GetYear(), 
					((COleDateTime)month2).GetMonth(), 
					month2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	m.IsValid();

	if (IsEmpty() && m.GetStatus() == COleDateTime::valid)
		return TRUE;
	if (m.IsEmpty())
		return FALSE;
	if (GetYear() < m.GetYear())
		return TRUE;
	if (GetYear() > m.GetYear())
		return FALSE;
	// Samma rtal
	return ((COleDateTime*)this)->GetMonth() < ((COleDateTime)m).GetMonth();
}

int	CPulMonth2::operator<=(const CPulMonth2 &month2)
{
	return *this < month2 || *this == month2;
}

int	CPulMonth2::operator>(const CPulMonth2 &month2)
{
	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	month2.GetYear(), 
					((COleDateTime)month2).GetMonth(), 
					month2.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	m.IsValid();

	if (m.IsEmpty() && GetStatus() == COleDateTime::valid)
		return TRUE;
	if (IsEmpty())
		return FALSE;
	if (GetYear() > m.GetYear())
		return TRUE;
	if (GetYear() < m.GetYear())
		return FALSE;
	// Samma rtal
	return ((COleDateTime*)this)->GetMonth() > ((COleDateTime)m).GetMonth();
}

int	CPulMonth2::operator>=(const CPulMonth2 &month2)
{
	return *this > month2 || *this == month2;
}

int	CPulMonth2::GetNrDays()
{
	CPulDate2	tmp;
	tmp.Init();
	tmp.SetDateTime(	GetYear(), 
						((COleDateTime*)this)->GetMonth(), 
						GetDay(), 
						MC_DATETIME_HOUR_INIT, 
						MC_DATETIME_MINUTE_INIT, 
						MC_DATETIME_SECOND_INIT);
	
	if (!tmp.IsValid())
		return 0;

	tmp.SetLastDayOfMonth();
	return tmp.GetDay();
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator-(CPulMonth2)
//
//	Operatorverlagring av - skillnaden mellan tv CPulMonth2-objekt
//	CPulMonth2-CPulMonth2
//
//	Indata:
//		Month			Hger delens CPulMonth-objekt i subtraktionen
//
//	Returvrde:
//		Returnerar antal mnader som skiljer de tv datumen
//	
//	OBS!
//		Funktionen returnerar differansen, EJ antal mnader i intervall.
//
long		CPulMonth2::operator-(const CPulMonth2& Month)
{
	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	Month.GetYear(), 
					((COleDateTime)Month).GetMonth(), 
					Month.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	
	if (!m.IsValid() || IsEmpty() || m.IsEmpty())
		return 0;
	return (GetYear() - m.GetYear()) * 12 + ((COleDateTime*)this)->GetMonth() - ((COleDateTime)m).GetMonth();
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::Valid
//
//	Kontrollerar om det r ett korrekt mnad
//
//	Returvrde:
//		Returnerar TRUE om det r korrekt annars FALSE
//
//	Anmrkning:
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
BOOL	CPulMonth2::IsValid()
{
	CPulDate2	date;
	date = *this;
	return date.IsValid();
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonthy::GetMonth
//
//	Lser aktuell manad
//
//	Returvrde:
//		Returnerar den aktuella mnaden som CString-objekt
//
CString	CPulMonth2::GetMonth()
{
	CString	str;

	str.Format("%04d%02d", GetYear(), ((COleDateTime*)this)->GetMonth());

	if (IsEmpty())
		str.Empty();

	return str;
}
CString	CPulMonth2::GetMonth4()
{
	CString	str;
	str.Format("%02d%02d", GetYear() % 100, ((COleDateTime*)this)->GetMonth());
	return str;
}

const char	*CPulMonth2::GetMonthStr()
{
	switch (((COleDateTime*)this)->GetMonth()) {
	case 1 :
		return "Januari";
	case 2 :
		return "Februari";
	case 3 :
		return "Mars";
	case 4 :
		return "April";
	case 5 :
		return "Maj";
	case 6 :
		return "Juni";
	case 7 :
		return "Juli";
	case 8 :
		return "Augusti";
	case 9 :
		return "September";
	case 10 :
		return "Oktober";
	case 11 :
		return "November";
	case 12 :
		return "December";
	default :
		return "";
	}
} 

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::SetMonth
//
//	Stter aktuell mnad
//
//	Returvrde:
//		Returnerar den aktuella mnaden som CString-objekt
//
//	Anmrkning:
//		Om aktuell mnad ej r korrekt (se Valid()) s sker ingen
//		frndring.
//
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&	CPulMonth2::SetMonth(CString Month)
{
	int	year;
	int	month;
	Init();
	switch (Month.GetLength()) {
	case 8 :	// MMDD, Fullt datum, ignorera dag
		year = atoi(Month.Mid(0,4));
		month = atoi(Month.Mid(4,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT))
			SetDateTime(year, month, 1, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
		break;
	case 6 :	// MM
		year = atoi(Month.Mid(0,4));
		month = atoi(Month.Mid(4,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT))
			SetDateTime(year, month, 1, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
		break;
	case 4 :	// 
		year = atoi(Month.Mid(0,2));
		if (year < 50)
			year += 2000;
		else
			year += 1900;
		month = atoi(Month.Mid(2,2));
		if ((year != 0 && year != MC_DATETIME_YEAR_INIT) ||
		    (month != 0 && month != MC_DATETIME_MONTH_INIT))
			SetDateTime(year, month, 1, MC_DATETIME_HOUR_INIT, MC_DATETIME_MINUTE_INIT, MC_DATETIME_SECOND_INIT);
		break;
	default :
		break;
	}
	IsValid();	// Stter rtt status
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::SetThisMonth
//
//	Stter aktuell mnad till innevarande mnad
//
//	Returvrde:
//		Returnerar innevarande mnad som ett CString-objekt
//
CPulMonth2&	CPulMonth2::SetThisMonth()
{
	struct tm	*today;
	time_t		ltime;
	char		szMonth[7];
	CString		str;

	time(&ltime);
	today = localtime(&ltime);
	strftime(szMonth, 7, "%Y%m", today);
	str.Format("%s", szMonth);
	return SetMonth(str);
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator=(CPulMonth2)
//
//	Operatorverlagring av = mellan tv CPulMonth2-objekt
//	CPulMonth2 = CPulMonth2
//
//	Indata:
//		Month			Hger delens objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulMonth2 = CPulMonth2);
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator=(const CPulMonth2 Month)
{
	if (Month.GetStatus() == COleDateTime::null) {
		Init();
		return *this;
	}

	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	Month.GetYear(), 
					((COleDateTime)Month).GetMonth(), 
					Month.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);

	if (!m.IsValid())
		return *this;

	Init();
	SetDateTime(	m.GetYear(), 
					((COleDateTime)m).GetMonth(), 
					m.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	IsValid();	// Stter rtt status

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator=(CPulMonth2)
//
//	Operatorverlagring av = frn CPulDate2-objekt till CPulMonth2-objekt
//	CPulMonth2 = CPulDate2
//
//	Indata:
//		Date			Hger delens objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulMonth2 = CPulDate2);
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator=(const CPulDate2 Date)
{
	if (Date.GetStatus() == COleDateTime::null) {
		Init();
		return *this;
	}

	CPulMonth2	m;
	m.Init();
	m.SetDateTime(	Date.GetYear(),		
					((COleDateTime)Date).GetMonth(), 
					1, 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);

	if (!m.IsValid())
		return *this;

	Init();
	SetDateTime(	m.GetYear(), 
					((COleDateTime)m).GetMonth(), 
					m.GetDay(), 
					MC_DATETIME_HOUR_INIT, 
					MC_DATETIME_MINUTE_INIT, 
					MC_DATETIME_SECOND_INIT);
	IsValid();	// Stter rtt status

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator=(CTime)
//
//	Operatorverlagring av = frn CTime-objekt till CPulMonth2-objekt
//	CPulDate2 = CTime
//
//	Indata:
//		Date			Hger delens CTime-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulMonth2 = CTime);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulMonth2&		CPulMonth2::operator=(const CTime Month)
{
	Init();
	CString	str;
	str.Format("%04d%02d", Month.GetYear(), Month.GetMonth());
	SetMonth(str);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator=(CString)
//
//	Operatorverlagring av = frn CString-objekt till CPulMonth2-objekt
//	CPulMonth2 = CString
//
//	Indata:
//		Month			Hger delens CString-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulMonth2 = CString);
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator=(const CString Month)
{
	SetMonth(Month);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator=(LPCSTR)
//
//	Operatorverlagring av = frn konstant strng till CPulMonth2-objekt
//	CPulMonth2 = "strng"
//
//	Indata:
//		lpszMonth			Hger delens strng i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulMonth2 = "strng");
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator=(LPCSTR lpszMonth)
{
	CString	str;
	str = lpszMonth;
	SetMonth(str);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator++
//
//	Operatorverlagring av ++CPulMonth2
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return ++CPulMonth2;
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator++()
{
	AddMonth(1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator++(int i)
//
//	Operatorverlagring av CPulMonth2++
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulMonth2++;
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator++(int)
{
	AddMonth(1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator--
//
//	Operatorverlagring av --CPulMonth2
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return --CPulMonth2;
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator--()
{
	AddMonth(-1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulMonth2::operator--(int i)
//
//	Operatorverlagring av CPulMonth2--
//
//	Returvrde:
//		Returnerar aktuellt CPulMonth2-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulMonth2--;
//	
//	Anmrkning:
//		Om mnaden ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta mnad:
//			blankt
//			MM
//			MM
//
CPulMonth2&		CPulMonth2::operator--(int)
{
	AddMonth(-1);
	return *this;
}



/********************************************************************************/
/*																				*/
/*	CPulDateDb																	*/
/*																				*/
/********************************************************************************/

/*
 *	Logiska jmfrelseoperatorer ==, <, <=, >, >=
 *
 *	Indata :
 *		date2		datum att jmfra med
 *
 *	Funktionsvrde :
 *		TRUE(1) om uppfyllt, annars FALSE(0)
 */
int	CPulDateDb::operator==(const CPulDateDb &date2)
{
	return m_dwDate.Day == date2.m_dwDate.Day && 
		m_dwDate.Month == date2.m_dwDate.Month && 
		m_dwDate.Year == date2.m_dwDate.Year;
}


int	CPulDateDb::operator!=(const CPulDateDb &date2)
{
	return m_dwDate.Day != date2.m_dwDate.Day ||
		m_dwDate.Month != date2.m_dwDate.Month ||
		m_dwDate.Year != date2.m_dwDate.Year;
}

int	CPulDateDb::operator<(const CPulDateDb &date2)
{
	if (m_dwDate.Year < date2.m_dwDate.Year)
		return TRUE;
	if (m_dwDate.Year > date2.m_dwDate.Year)
		return FALSE;
	// Samma rtal
	if (m_dwDate.Month < date2.m_dwDate.Month)
		return TRUE;
	if (m_dwDate.Month > date2.m_dwDate.Month)
		return FALSE;
	// Samma mnad
	return m_dwDate.Day < date2.m_dwDate.Day;
}

int	CPulDateDb::operator<=(const CPulDateDb &date2)
{
	return *this < date2 || *this == date2;
}

int	CPulDateDb::operator>(const CPulDateDb &date2)
{
	if (m_dwDate.Year > date2.m_dwDate.Year)
		return TRUE;
	if (m_dwDate.Year < date2.m_dwDate.Year)
		return FALSE;
	// Samma rtal
	if (m_dwDate.Month > date2.m_dwDate.Month)
		return TRUE;
	if (m_dwDate.Month < date2.m_dwDate.Month)
		return FALSE;
	// Samma mnad
	return m_dwDate.Day > date2.m_dwDate.Day;
}

int	CPulDateDb::operator>=(const CPulDateDb &date2)
{
	return *this > date2 || *this == date2;
}

/********************************************************************************/
/*																				*/
/*	CPulDate																	*/
/*																				*/
/********************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// CPulDate::Valid
//
//	Kontrollerar om det r ett korrekt datum
//
//	Returvrde:
//		Returnerar TRUE om det r korrekt annars FALSE
//
//	Anmrkning:
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
BOOL	CPulDateDb::IsValid()
{
	CString	date = GetDate();

	if (date.IsEmpty())
		return TRUE;

	if (date.Mid(0,1) == "D" || date.Mid(0,1) == "G" || date.Mid(0,1) == "M")
		return TRUE;

	DWORD_DATE	dwDate = m_dwDate;
	int			lyr = 0;

	if (dwDate.Year < 100) {
		if (dwDate.Year < 50)
			dwDate.Year += 2000;
		else
			dwDate.Year += 1900;
	}
	if (dwDate.Year < 1000)
		dwDate.Year += 2000;
	if (dwDate.Month < 1 || dwDate.Month > 12) 
		return FALSE;
	if(dwDate.Day < 1 || dwDate.Day > 31)
		return FALSE;
	if (dwDate.Day > 30 && (dwDate.Month == 4 || dwDate.Month == 6 || dwDate.Month == 9 || dwDate.Month == 11))
		return FALSE;
	if (dwDate.Month == 2 && dwDate.Day > 28) {
		if (dwDate.Year == (4*(dwDate.Year/4)))
			lyr = 1;
		if (dwDate.Year == (100*(dwDate.Year/100)))
			lyr = 0;
		if (dwDate.Year == (400*(dwDate.Year/400)))
			lyr = 1;
		if (!lyr)
			return FALSE;
		else {
			if (dwDate.Day > 29)
				return FALSE;
		}
	}

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::SetCentury
//
//	Lgger till sekelskiftessiffra
//
//	Returvrde:
//		Returnerar det nya datumet som CString-objekt
//
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD	(ingen frndring)
//
CPulDateDb &CPulDateDb::SetCentury()
{
	if (IsEmpty())
		return *this;

	if (m_dwDate.Year < 100) {
		if (m_dwDate.Year < 50)
			m_dwDate.Year += 2000;
		else
			m_dwDate.Year += 1900;
	}
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::GetDate
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt
//
CString	CPulDateDb::GetDate()
{
	CString	str;

	if (m_dwDate.Year < 100)
		str.Format("%02d%02d%02d", m_dwDate.Year, m_dwDate.Month, m_dwDate.Day);
	else
		str.Format("%04d%02d%02d", m_dwDate.Year, m_dwDate.Month, m_dwDate.Day);

	if (m_dwDate.Year == 0 && m_dwDate.Month == 0 && m_dwDate.Day == 0)
		str.Empty();

	return str;
}

// CPulDate::GetDate2
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt med - mellan delarna
//
CString	CPulDateDb::GetDate2()
{
	CString	str;

	if (m_dwDate.Year < 100)
		str.Format("%02d-%02d-%02d", m_dwDate.Year, m_dwDate.Month, m_dwDate.Day);
	else
		str.Format("%04d-%02d-%02d", m_dwDate.Year, m_dwDate.Month, m_dwDate.Day);

	if (m_dwDate.Year == 0 && m_dwDate.Month == 0 && m_dwDate.Day == 0)
		str.Empty();

	return str;
}

// CPulDate::GetDate2
//
//	Lser aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt enligt format MMDD
//
CString	CPulDateDb::GetDate6()
{
	CString	str;

	str.Format("%02d%02d%02d", m_dwDate.Year % 100, m_dwDate.Month, m_dwDate.Day);

	if (m_dwDate.Year == 0 && m_dwDate.Month == 0 && m_dwDate.Day == 0)
		str.Empty();

	return str;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::SetDate
//
//	Stter aktuellt datum
//
//	Returvrde:
//		Returnerar det aktuella datumet som CString-objekt
//
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&	CPulDateDb::SetDate(CString Date)
{
	m_dwDate.Year	= 0;
	m_dwDate.Month	= 0;
	m_dwDate.Day	= 0;
	if (Date.GetLength() == 10) {		// -MM-DD
		m_dwDate.Year	= atoi(Date.Mid(0,4));
		m_dwDate.Month	= atoi(Date.Mid(5,2));
		m_dwDate.Day	= atoi(Date.Mid(8,2));
	}
	else if (Date.GetLength() == 8) {	// MMDD
		m_dwDate.Year	= atoi(Date.Mid(0,4));
		m_dwDate.Month	= atoi(Date.Mid(4,2));
		m_dwDate.Day	= atoi(Date.Mid(6,2));
	}
	else if (Date.GetLength() == 6) {	// MMDD
		m_dwDate.Year	= atoi(Date.Mid(0,2));
		m_dwDate.Month	= atoi(Date.Mid(2,2));
		m_dwDate.Day	= atoi(Date.Mid(4,2));
		SetCentury();
	}
	else if (Date.Mid(0,1) == 'D')		// Initiera till dagens datum
		SetToday();
	else if (Date.Mid(0,1) == 'G') {	// Initiera till grdagens datum
		SetToday();
		(*this)--;
	}
	else if (Date.Mid(0,1) == 'M') {	// Initiera till morgondagens datum
		SetToday();
		(*this)++;
	}
	return *this;
}


CPulDateDb CPulDateDb::GetToday()
{
	CPulDateDb	idag;
	idag.SetToday();
	return idag;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::SetToday
//
//	Stter aktuellt datum till dagens datum
//
//	Returvrde:
//		Returnerar dagens datum som ett CString-objekt
//
CPulDateDb&	CPulDateDb::SetToday()
{
	struct tm	*today;
	time_t		ltime;
	char		date[9];
	CString		str;

	time(&ltime);
	today = localtime(&ltime);
	strftime(date, 9, "%Y%m%d", today);
	str.Format("%s", date);
	return SetDate(str);
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::SetLastDayOfMonth
//
//	Stter aktuellt datum sista dagen i mnaden
//
//	Returvrde:
//		Returnerar sista dagen i mnaden som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&	CPulDateDb::SetLastDayOfMonth()
{

	CString	str = GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);

	m_dwDate.Day = 28;
	BYTE	Month = m_dwDate.Month;
	(*this)++;
	while(m_dwDate.Month == Month) {
		Month = m_dwDate.Month;
		(*this)++;
	}
	(*this)--;
	return *this;
}

CPulDateDb&	CPulDateDb::SetFirstDayOfMonth()
{

	CString	str = GetDate();
	SetDate(str);
	m_dwDate.Day = 01;
	return *this;
}


/////////////////////////////////////////////////////////////////////////////
// CPulDate::AddYear
//
//	Adderar r i aktuellt datum med ett angivet antal r
//
//	Indata:
//		Years			Antal r som r i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&	CPulDateDb::AddYear(int Years)
{
	if (m_dwDate.Year < 100) {
		m_dwDate.Year += Years;
		while(m_dwDate.Year > 100)
			m_dwDate.Year -= 100;
		while(m_dwDate.Year < 0)
			m_dwDate.Year += 100;
	}
	else {
		m_dwDate.Year += Years;;
		while(m_dwDate.Year > 10000)
			m_dwDate.Year -= 10000;
		while(m_dwDate.Year < 0)
			m_dwDate.Year += 10000;
	}
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::AddMonth
//
//	Adderar Mnad i aktuellt datum med ett angivet antal mnader
//
//	Indata:
//		Months			Antal mnader som Mnad i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&	CPulDateDb::AddMonth(int Months)
{

	// Om man backar mer n en mnad bakt ver ett rsskifte
	// anropas funktionen rekursivt dr man backar en mnad i taget
	// detta eftersom m_dwMonth.Month r "unsigned" och ej kan vara negativ
	if(((int)m_dwDate.Month) < (-1*Months)){
		AddMonth(Months + 1);
		Months = -1;
	}

	m_dwDate.Month += Months;
	if (m_dwDate.Month > 12) {
		AddYear((int)m_dwDate.Month/12);
		m_dwDate.Month = (int)m_dwDate.Month % 12;
	}
	if (m_dwDate.Month < 1) {
		AddYear((int)m_dwDate.Month/12-1);
		m_dwDate.Month = 12 + ((int)m_dwDate.Month % 12);
	}
	return *this;
}


/*
 *	Funktionen tar fram ett datum ett antal veckor och dagar fram i tiden.
 *
 *	Indata :
 *		*datum		Startdatum.
 *		veckor		Antalet veckor framt i tiden.
 *		dagar		Antaler dagar efter antalet veckor framt
 *				i tiden.
 *
 *	Utdata :
 *		*dest		Area dr det framtagna datumet lggs.
 */
CPulDateDb&	CPulDateDb::AddWeeksAndDays(int nVeckor, int nDagar)
{
	SetFromJulianDate(ToJulianDate() + (nVeckor * 7) + nDagar);
	return *this;
} // CPulDateDb::AddWeeksAndDays

/////////////////////////////////////////////////////////////////////////////
// CPulDate::AddDay
//
//	Adderar Dag i aktuellt datum med ett angivet antal dagar
//
//	Indata:
//		Days			Antal dagar som Dag i aktuellt datum skall adderas
//
//	Returvrde:
//		Returnerar det nya datumet som ett CString-objekt
//	
//	Anmrkning:
//		Om aktuellt datum ej r korrekt (se Valid()) s sker ingen
//		frndring.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&	CPulDateDb::AddDay(int Days)
{
	if (Days > 0) {
		for (int i = 0; i < Days; i++) {
			m_dwDate.Day++;
			if (m_dwDate.Day > 28) {
				if (!IsValid()) {
					m_dwDate.Day = 1;
					AddMonth(1);
				}
			}
		}
	}
	else {
		for (int i = 0; i < Days*-1; i++) {
			m_dwDate.Day--;
			if (m_dwDate.Day < 1) {
				m_dwDate.Day = 31;
				AddMonth(-1);
			}
			while(!IsValid())
				m_dwDate.Day--;
		}
	}
	return *this;
}


/*
 *	1998-07-29	Ulf
 *	Tar reda p vilken veckodag det r
 *
 *	Returvrde:
 *		Returnerar aktuell veckodag 1=Sndag, 2=Mndag, ... 7=Lrdag
 */
int	CPulDateDb::DayOfWeek()
{
	return 1;
}

CString	CPulDateDb::GetDayStr(int nDayno)
{
	switch (nDayno == 0 ? DayOfWeek() : nDayno) {
	case 1 :
		return "Sndag";
		break;
	case 2 :
		return "Mndag";
		break;
	case 3 :
		return "Tisdag";
		break;
	case 4 :
		return "Onsdag";
		break;
	case 5 :
		return "Torsdag";
		break;
	case 6 :
		return "Fredag";
		break;
	case 7 :
		return "Lrdag";
		break;
	}
	return "";	// Ska inte intrffa
} // CPulDateDb::GetDayName


CPulDateDb	&CPulDateDb::SetFirstMondayOfYear(int year)
{
	switch (year) {
	case 85 :
	case 1985 :	return SetDate("19841231");
	case 86 :
	case 1986 :	return SetDate("19851230");
	case 87 :
	case 1987 :	return SetDate("19870104");
	case 88 :
	case 1988 :	return SetDate("19880103");
	case 89 :
	case 1989 :	return SetDate("19890102");
	case 90 :
	case 1990 :	return SetDate("19900101");
	case 91 :
	case 1991 :	return SetDate("19901231");
	case 92 :
	case 1992 :	return SetDate("19911230");
	case 93 :
	case 1993 :	return SetDate("19930104");
	case 94 :
	case 1994 :	return SetDate("19940103");
	case 95 :
	case 1995 :	return SetDate("19950102");
	case 96 :
	case 1996 :	return SetDate("19960101");
	case 97 :
	case 1997 :	return SetDate("19961230");
	case 98 :
	case 1998 :	return SetDate("19971229");
	case 99 :
	case 1999 :	return SetDate("19990104");
	case 00 :
	case 2000 :	return SetDate("20000103");
	case 01 :
	case 2001 :	return SetDate("20010101");
	case 02 :
	case 2002 :	return SetDate("20011231");
	case 03 :
	case 2003 :	return SetDate("20021230");
	case 04 :
	case 2004 :	return SetDate("20031229");
	case 05 :
	case 2005 :	return SetDate("20050103");
	case 06 :
	case 2006 :	return SetDate("20060102");
	case 07 :
	case 2007 :	return SetDate("20070101");
	case 8 :
	case 2008 :	return SetDate("20071231");
	case 9 :
	case 2009 :	return SetDate("20081229");
	case 10 :
	case 2010 :	return SetDate("20100104");
	}
	return *this;
}

/*
 *	Stter aktuell dag till frsta dagen (mndag) i begrd vecka utifrn r och veckonr
 */
	CPulDateDb	&CPulDateDb::SetDate(int year, int weeknr)
{
	SetFirstMondayOfYear(year);
	return SetFromJulianDate(ToJulianDate() + (weeknr-1) * 7);
}


/*
 * 	Veckonumrering
 *	--------------
 *
 *	r 1972 faststlldes svensk standard fr veckonumrering
 *	(SIS 0102 12) och fr datumskrivning (SIS 0102 11). Fr.o.m.
 *	1973 tillmpar vi SIS-standarden fr veckonumrering. Denna
 *	innebr att ett veckonummer alltid svarar mot 7 dagar, och att
 *	vecka 1 r den frsta vecka som innehller 4 dagar eller mer av
 *	det nya ret. Mndagen betraktas som veckans frsta dag.
 *	SIS-standarden fr datumskrivning innebr, att d datum an-
 *	gives uteslutande med siffror, skall det skrivas i ordningen:
 *	r-mnad-dag, t.ex. 1990-02-28.
 */

/*
 *	Hmtar veckonummer frn aktuellt datum
 */
int		CPulDateDb::GetWeekNr()
{
	CPulDateDb	start;
	start.SetFirstMondayOfYear(m_dwDate.Year);
	if (ToJulianDate() < start.ToJulianDate())
	{
		//	ret brjar med sista veckan frn fregende r, kan vara 52 eller 53.
		//	Hmta veckonummer frn sista dagen i fregende r
		CPulDateDb tmp = *this;
		tmp.m_dwDate.Year--;
		tmp.m_dwDate.Month = 12;
		tmp.m_dwDate.Day = 31;
		return tmp.GetWeekNr();
	}
	else
		return 1 + (ToJulianDate() - start.ToJulianDate()) / 7;
}

/////////////////////////////////////////////////////////////////////////////
//
//	Konvertering till och frn Julianskt datumsystem
//	Koden kopierad frn Vitamin C
//
//	Konvertering till Julianskt datumformat
//
long	CPulDateDb::ToJulianDate()
{
	long	ctmp, dtmp, mtmp, ytmp;
	long	result1, result2, result3;
	if (m_dwDate.Month > 2) {
		mtmp = m_dwDate.Month - 3;
		ytmp = m_dwDate.Year;
	}
	else {
		mtmp = m_dwDate.Month + 9;
		ytmp = m_dwDate.Year - 1;
	}
	ctmp	= ytmp / 100;
	dtmp	= ytmp - (100 * ctmp);
	result1 = 146097L * ctmp / 4;
	result2 = (1461 * dtmp) / 4;
	result3	= (153 * mtmp + 2) / 5;
	return result1 + m_dwDate.Day + result2 + 1721119L + result3;
} // CPulDateDb::ToJulianDate

//
//	Konvertering frn Julianskt datumformat
//
CPulDateDb	&CPulDateDb::SetFromJulianDate(long lJulian)
{
	long	yr, mo, da, mtmp;
	mtmp	= lJulian - 1721119L;
	yr		= (4 * mtmp - 1) / 146097L;
	mtmp	= 4 * mtmp - 1- 146097L * yr;
	da		= mtmp / 4;
	mtmp	= ( 4 * da + 3) / 1461;
	da		= 4 * da + 3 - 1461 * mtmp;
	da		= (da + 4) / 4;
	mo		= (5 * da - 3) / 153;
	da		= 5 * da - 3 - 153 * mo;
	da		= (da + 5) / 5;
	yr		= 100 * yr + mtmp;
	if (mo < 10)
		mo += 3;
	else {
		mo -= 9;
		yr++;
	}
	m_dwDate.Year	= (unsigned short)yr;
	m_dwDate.Month	= (unsigned char)mo;
	m_dwDate.Day	= (unsigned char)da;
	return *this;
} // CPulDateDb::SetFromJulianDate



/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator=(CPulDate)
//
//	Operatorverlagring av = mellan tv CPulDate-objekt
//	CPulDate = CPulDate
//
//	Indata:
//		Date			Hger delens objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate = CPulDate);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate&		CPulDate::operator=(const CPulDate Date)
{
	CPulDate	d = Date;
	if (!d.IsValid())
		return *this;

	CString	str = d.GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);
	else
		m_dwDate = Date.m_dwDate;

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator=(CPulDate)
//
//	Operatorverlagring av = mellan tv CPulDate-objekt
//	CPulDate = CPulDate
//
//	Indata:
//		Date			Hger delens objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate = CPulDate);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate&		CPulDate::operator=(const CPulDate2 Date)
{
	CPulDate	d;

	d.m_dwDate.Year = Date.GetYear();
	d.m_dwDate.Month = (BYTE)Date.GetMonth();
	d.m_dwDate.Day = (BYTE)Date.GetDay();
	if (!d.IsValid())
		return *this;

	CString	str = d.GetDate();
	if (str.Mid(0,1) == "D" || str.Mid(0,1) == "G" || str.Mid(0,1) == "M")
		SetDate(str);
	else
		*this = d;

	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator=(CString)
//
//	Operatorverlagring av = frn CString-objekt till CPulDate-objekt
//	CPulDate = CString
//
//	Indata:
//		Date			Hger delens CString-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate = CString);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate&		CPulDate::operator=(const CString Date)
{
	SetDate(Date);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator=(LPCSTR)
//
//	Operatorverlagring av = frn konstant strng till CPulDate-objekt
//	CPulDate = "strng"
//
//	Indata:
//		lpszDate			Hger delens strng i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate = "strng");
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDate&		CPulDate::operator=(LPCSTR lpszDate)
{
	CString	str;
	str = lpszDate;
	SetDate(str);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator=(LPCSTR)
//
//	Operatorverlagring av = frn CTime-objekt till CPulDate-objekt
//	CPulDate = CTime
//
//	Indata:
//		Date			Hger delens CTime-objekt i tilldelningen
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return (CPulDate = CTime);
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//
CPulDate&		CPulDate::operator=(const CTime Date)
{
	SetDate(Date.Format("%Y-%m-%d"));
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator++
//
//	Operatorverlagring av ++CPulDate
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return ++CPulDate;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&		CPulDateDb::operator++()
{
	SetFromJulianDate(ToJulianDate() + 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator++(int i)
//
//	Operatorverlagring av CPulDate++
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulDate++;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&		CPulDateDb::operator++(int)
{
	SetFromJulianDate(ToJulianDate() + 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator--
//
//	Operatorverlagring av --CPulDate
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return --CPulDate;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&		CPulDateDb::operator--()
{
	SetFromJulianDate(ToJulianDate() - 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator--(int i)
//
//	Operatorverlagring av CPulDate--
//
//	Returvrde:
//		Returnerar aktuellt CPulDate-objekt efter tilldeningen
//		dvs tillter programrader typ:
//		return CPulDate--;
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s sker ingen
//		tilldelning.
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
CPulDateDb&		CPulDateDb::operator--(int)
{
	SetFromJulianDate(ToJulianDate() - 1);
	return *this;
}

/////////////////////////////////////////////////////////////////////////////
// CPulDate::operator-(CPulDate)
//
//	Operatorverlagring av - skillnaden mellan tv CPulDate-objekt
//	CPulDate-CPulDate
//
//	Indata:
//		Date			Hger delens CPulDate-objekt i subtraktionen
//
//	Returvrde:
//		Returnerar antal dagar som skiljer de tv datumen
//	
//	Anmrkning:
//		Om datumet ej r korrekt (se Valid()) s returneras 0;
//	
//		Korrekta datum:
//			blankt
//			D			(dagens datum)
//			G			(grdagens datum)
//			M			(morgondagens datum)
//			MMDD
//			MMDD
//
//	OBS!
//		Funktionen returnerar differansen, EJ antal dagar i intervall.
//
long		CPulDateDb::operator-(const CPulDateDb& Date)
{
	if (IsEmpty() || ((CPulDateDb &)Date).IsEmpty())
		return 0;
	return ToJulianDate() - ((CPulDateDb &)Date).ToJulianDate();
}



/*
 *	Returnerar det interna format
 *	Br ej anvndas men krvs d CPulDate inte accepteras som del av union
 *
 *	Funktionsvrde :
 *		intern representation av datum-vrde
 */
long		CPulDateDb::GetAsLong()
{
	union {
		DWORD_DATE	dwdate;
		long		longdate;
	} date;
	date.dwdate = m_dwDate;
	return date.longdate;
} // CPulDate::GetAsLong


/*
 *	Stter vrdet p ett datum via det interna formatet.
 *	Br ej anvndas med krvs d CPulDate inte accepteras som del av union
 *
 *	Indata :
 *		datum	intern representation av datum-vrde
 */
void		CPulDateDb::SetFromLong(long datum)
{
	union {
		DWORD_DATE	dwdate;
		long		longdate;
	} date;
	date.longdate = datum;
	m_dwDate = date.dwdate;
} // CPulDate::SetFromLong

/*
 *	Syfte:	Anger om inparameterns datum r ett datum i samma mnad (och r) som klassens datum.	
 *	
 *	Indata:	
 *		sDate	Datum 
 *
 *	Retur:
 *		true	Om datumen r datum i samma r och mnad
 *		false	Om datumen inte r datum i samma r och mnad
 */
bool CPulDateDb::SameMonth(CString sDate)
{
	CPulDateDb date;
	date.SetDate(sDate);
	return m_dwDate.Year == date.m_dwDate.Year && m_dwDate.Month == date.m_dwDate.Month;
}


