/*
 *	Filnamn:		CustomCtrl.cpp
 *	Syfte  :		Egendefinierade kontroller
 *					Alla kontroller mste registreras innan anvndning, vilket 
 *					grs med funktionen RegisterControlClass fr respektive 
 *					kontroll.
 */
#include "stdafx.h"
#include <afxdtctl.h>
#if _MFC_VER < 0x0700
#include <ctl3d.h>
#endif
//#include "MCResource.h"
//#include "PulCustomCtrl.h"
//#include "StdDefines.h"
//#include "DBHandler.h"
//#include "Message.h"
//#include "UsefulFuncs.h"
//#if defined(SQL)
//#include "KodBlankettTypSet.h"
//#include "KodBlankettVariantSet.h"
//#include "KodMeddGruppSet.h"
//#endif
#include "resource.h"
#include "CustomCtrl.h"
#if defined(AHO_SYSTEM)
#include "..\..\Aho\MainFrm.h"
#endif



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDatumCtrl window
//
//	Denna kontroll hanterar ett datum-flt med kalender
//	
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
CDatumCtrl::CDatumCtrl()
{
//	m_bKillFocus = FALSE;
	m_bVal = TRUE;
	m_bPopupButtonPressed = FALSE;
	m_pButton = NULL;
	m_bCPulDate2 = false;
}

CDatumCtrl::~CDatumCtrl()
{
	delete m_pButton;
}

void	CDatumCtrl::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDateDb		*pDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, pDocValue, wType, lpszInitStr);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

void	CDatumCtrl::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDate2		*pDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	m_bCPulDate2 = true;
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, pDocValue, wType, lpszInitStr);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

void	CDatumCtrl::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, NULL, 0, NULL);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

#define	digit_sum(nr)	((nr) > 9 ? 1+(nr) : (nr))
#define	ctoi(nr)		((nr) - '0')

/////////////////////////////////////////////////////////////////////////////
// Validate
//		Denna medlemsfunktion kontrollerar om det r ett korrekt personnummer.
//	
//	Returvrde:
//		Returnerar TRUE om det r ett korrekt personnummer, annars FALSE
//
//	Anmrkning:
//		Korrekta personnummer:
//			MMDDXXXX
//			MMDD-XXXX
//			MMDDXXXX
//			MMDD-XXXX
//		Den kontrollerar ocks att det r rtt checksiffra.
//
BOOL	CDatumCtrl::Validate()
{
	CString		str;
	CPulDate	date;

	GetWindowText(str);

	if (str.Left(1) == "2" && str.GetLength() < 8)
		return FALSE;

	date.SetDate(str);
	
	if (!str.IsEmpty() && date.IsEmpty())
		return FALSE;

	return date.IsValid();
}


/////////////////////////////////////////////////////////////////////////////
// Format
//		Denna medlemsfunktion formatterar editfltets personnummer till 
//		utseendet MMDD-XXXX.
//		Det frutstts att personnumret r korrekt (se Validate).
//	
void	CDatumCtrl::Format()
{
	CString		str;
	CPulDate	date;

	GetWindowText(str);
	date.SetDate(str);
	date.SetCentury();

	m_nFormatFlag = TRUE;
	str = date.GetDate2();
	SetWindowText(str);
}

int	CDatumCtrl::GetFieldValue(CPulDateDb *pDest)
{
	if (pDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	pDest->SetDate(str);
	return str.GetLength();
}

int	CDatumCtrl::GetFieldValue(CPulDate2 *pDest)
{
	if (pDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	pDest->SetDate(str);
	return str.GetLength();
}

int	CDatumCtrl::GetFieldValue(LPSTR lpszDest)
{
	if (lpszDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	strcpy((LPSTR)lpszDest, str);
	return str.GetLength();
}

/*	
 *	Syfte:	
 *		verlagrar CEdit::MoveWindow(). Flyttar kontrollen enligt lpRect. Flyttar ven knappen.
 *
 *	Indata:	
 *		lpRect		Anger de koordinater som kontrollen skall flyttas till, mste vara i 
 *					frhllande till kontrollens parent.
 *		bRepaint	Defaultvrde = 1, anger om omritning skall gras.
 *
 *	Utdata:
 *		Inga
 *
 *	Ex:	
 *		Exempel fr CMultiKodEdit kan verfras till CDatumCtrl
 *		//	IDC_HSLKATEGORI r en CMultiKodEdit kontroll. ccHslKategori() "returnerar kontrollen".
 *		//	Flytta IDC_HSLKATEGORI till samma vnsterlge som IDC_PERSNR.
 *	
 *		CRect	rectPersNr, rectKategori;
 *		WINDOWPLACEMENT lpwndplPersnr, lpwndplKategori;
 *
 *		GetDlgItem(IDC_PERSNR)->GetWindowPlacement(&lpwndplPersnr);	//	Hmta referens koordinater
 *		GetDlgItem(IDC_HSLKATEGORI)->GetWindowPlacement(&lpwndplKategori);	//	Hmta kooridinater
 *		rectPersNr		= lpwndplPersnr.rcNormalPosition;
 *		rectKategori	= lpwndplKategori.rcNormalPosition;
 *		
 *		int nKategoriBredd	= rectKategori.Width();
 *		rectKategori.left	= rectPersNr.left;						//	ndra koordinatvrdet left
 *		rectKategori.right	= rectKategori.left + nKategoriBredd;	//	ndra koordinatvrdet right
 *		ccHslKategori().MoveWindow(rectKategori);				//	Flytta CMultiKodEdit kontrollen
 */
void CDatumCtrl::MoveWindow(LPCRECT lpRect, BOOL bRepaint)
{
	int nEditWidth	= lpRect->right - lpRect->left;
	int nEditHeight = lpRect->bottom - lpRect->top;

	CRect rectParent, rectButton;
	WINDOWPLACEMENT lpwndpl;

	m_pButton->GetWindowPlacement(&lpwndpl);			//	Hmta koordinater fr knappen
	rectButton = lpwndpl.rcNormalPosition;

	int nButtonWidth = rectButton.Width();
	rectButton.left = lpRect->right;					//	ndra knappkoordinater
	rectButton.right = lpRect->right + nButtonWidth;	

	CEdit::MoveWindow(lpRect->left, lpRect->top, nEditWidth, nEditHeight, bRepaint);
	m_pButton->MoveWindow(rectButton);					//	Flytta knappen
}//	MoveWindow()

LRESULT CALLBACK EXPORT	CDatumCtrl::WndProcHook(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CDatumCtrl	*pEdit = new CDatumCtrl();
	pEdit->Attach(hWnd);
	pEdit->m_pfnSuper = lpfnWndProc;
	SetWindowLong(hWnd, GWL_WNDPROC, (DWORD)AfxWndProc);
#if _MFC_VER < 0x0700
#ifndef _MAC
	pEdit->SubclassCtl3d(CTL3D_EDIT_CTL);
#endif
#endif
#ifdef STRICT
	return CallWindowProc(AfxWndProc, hWnd, msg, wParam, lParam);
#else
	return CallWindowProc((FARPROC)AfxWndProc, hWnd, msg, wParam, lParam);
#endif
}


WNDPROC	CDatumCtrl::lpfnWndProc = NULL;

BOOL	CDatumCtrl::RegisterControlClass()
{
	WNDCLASS	wc;

	static const TCHAR	lpszClassName[] = _T("DatumCtrl");
	if (GetClassInfo(AfxGetInstanceHandle(), lpszClassName, &wc)) 
		return (wc.lpfnWndProc == (WNDPROC)WndProcHook); // Redan registrerad
	
	// Anvnd "edit" som template
	GetClassInfo(NULL, _T("edit"), &wc);
	lpfnWndProc = wc.lpfnWndProc;

	// Lgger in de nya vrdena
	wc.lpfnWndProc		= WndProcHook;
	wc.hInstance		= AfxGetInstanceHandle();
	wc.lpszClassName	= lpszClassName;
	return (RegisterClass(&wc) != 0);
}



BEGIN_MESSAGE_MAP(CDatumCtrl, CEdit)
	//{{AFX_MSG_MAP(CDatumCtrl)
	ON_WM_CHAR()
	ON_WM_CREATE()
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(EN_SETFOCUS, OnSetfocus)
	ON_WM_KEYDOWN()
	ON_WM_ENABLE()
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
	ON_MESSAGE(AM_EMPTY, OnEmpty)
	ON_MESSAGE(AM_DOC2VIEW, OnDocToView)
	ON_MESSAGE(AM_VIEW2DOC, OnViewToDoc)
	ON_MESSAGE(AM_VALIDATE, OnValidate)
	ON_MESSAGE(AM_CHECK_UPDATE_STATE, OnCheckUpdateState)
	ON_MESSAGE(AM_KODPOPUP, OnKalenderPopup)
	ON_MESSAGE(AM_FIELD_LOST_FOCUS, OnFieldLostFocus)
	ON_MESSAGE(AM_POPUPBUTTONPRESSED, OnPopupButtonPressed)
	ON_MESSAGE(AM_DO_NOT_VALIDATE, OnDoNotValidate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDatumCtrl message handlers

int CDatumCtrl::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CEdit::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//	Anpassar bredden p Edit-fltet
	WINDOWPLACEMENT	wpEC;
	GetWindowPlacement(&wpEC);
	//	Eftersom VISIBLE inte r satt nnu nr OnCreate() krs r vrdet wpEC.showCmd inte definierat 
	//	The CWnd object receives OnCreate call after the window is created but before it becomes visible
	wpEC.showCmd = lpCreateStruct->style & WS_VISIBLE ? SW_SHOW : SW_HIDE;
	wpEC.rcNormalPosition.right = wpEC.rcNormalPosition.right - 15;
	VERIFY(SetWindowPlacement(&wpEC) != 0);

	m_pButton = new CKodPopupButton(this);
	CRect	rect(wpEC.rcNormalPosition.right, 
				 wpEC.rcNormalPosition.top, 
				 wpEC.rcNormalPosition.right+15,
				 wpEC.rcNormalPosition.bottom);
	
	VERIFY(m_pButton->Create("Kodpopup", lpCreateStruct->style & WS_VISIBLE | BS_PUSHBUTTON | BS_OWNERDRAW, rect, 
					  FromHandle(lpCreateStruct->hwndParent), MC_IDC_KODPOPUP) != 0);
	VERIFY(m_pButton->LoadBitmaps(MC_IDB_KODPOPUPU, MC_IDB_KODPOPUPD, MC_IDB_KODPOPUPU, MC_IDB_KODPOPUPDI) != 0);
  
	return 0;
}

void CDatumCtrl::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar != '-' && IsCharAlpha((TCHAR)nChar))
		return;
	CEdit::OnChar(nChar, nRepCnt, nFlags);
}

void CDatumCtrl::OnChange() 
{
	CString		str;	
	GetWindowText(str);
	CCustomCtrl::OnChange(&str);
	m_pParent->SendMessage(EN_CHANGE);
}

void CDatumCtrl::OnKillfocus() 
{
	CWnd	*pwndFocus = m_pParent->GetFocus();
	int		nIDFocus = pwndFocus == NULL ? 0 :pwndFocus->GetDlgCtrlID();
	if (pwndFocus != NULL && nIDFocus == MC_IDC_KODPOPUP) {
		WINDOWPLACEMENT	wpEC, wpFocus;
		GetWindowPlacement(&wpEC);
		pwndFocus->GetWindowPlacement(&wpFocus);
		if (wpEC.rcNormalPosition.right == wpFocus.rcNormalPosition.left &&
		    wpEC.rcNormalPosition.top == wpFocus.rcNormalPosition.top)
			return;	// Man har tryckt p popup-knapp till fltet
	}
	if (!m_bVal) {
		m_bVal = TRUE;
		return;
	}
/*	if (!m_bKillFocus) {
		*
		 *	Special fr att tillta att man fr upp kalendern p ett flt
		 *	som inte tillter blankt vrde.
		 *
		m_bKillFocus = TRUE;
		PostMessage(AM_FIELD_LOST_FOCUS);
		return;
	}
	m_bKillFocus = FALSE; */
	CString		str;	
	GetWindowText(str);
	CCustomCtrl::OnKillfocus(&str);
	m_pParent->SendMessage(EN_KILLFOCUS);
}

LONG	CDatumCtrl::OnFieldLostFocus(UINT wParam, LONG lParam)
{
	if (!m_bPopupButtonPressed)
		OnKillfocus();
	m_bPopupButtonPressed = FALSE;
	return 0L;
}

LONG	CDatumCtrl::OnPopupButtonPressed(UINT wParam, LONG lParam)
{
	m_bPopupButtonPressed = TRUE;;
	return 0L;
}

void CDatumCtrl::OnSetfocus() 
{
	m_bVal = TRUE;
	m_bPopupButtonPressed = FALSE;
	CString	str;
	GetWindowText(str);
	CCustomCtrl::OnSetfocus(&str);
	m_pParent->SendMessage(EN_SETFOCUS);
}

LONG	CDatumCtrl::OnEmpty(UINT wParam, LONG lParam)
{
	SetWindowText(*CCustomCtrl::OnEmpty());
	return 0L;
}

LONG	CDatumCtrl::OnDocToView(UINT wParam, LONG lParam)
{
	if (m_pDocValue) {
		if (m_bCPulDate2)
			*m_pViewValue = ((CPulDate2*)m_pDocValue)->GetDate2();
		else
			*m_pViewValue = ((CPulDate*)m_pDocValue)->GetDate2();
	}
	
	return 0L;
}

LONG	CDatumCtrl::OnViewToDoc(UINT wParam, LONG lParam)
{
	if (m_pDocValue) {
		CString	str;
		GetWindowText(str);
		if (!Validate()) 
			OnError();
//			m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
		else {
			Format();
			GetWindowText(*m_pViewValue);
			if (m_bCPulDate2)
				((CPulDate2*)m_pDocValue)->SetDate(*m_pViewValue);
			else
				((CPulDate*)m_pDocValue)->SetDate(*m_pViewValue);
		}
	}
	return 0L;
}

LONG	CDatumCtrl::OnValidate(UINT wParam, LONG lParam)
{
	CString	str;
	GetWindowText(str);
	if (str.IsEmpty() && (m_wType & CC_NOT_BLANK)) {
		OnError();
		return 0L;
	}
	CCustomCtrl::OnValidate();
	return 0L;
}

LONG	CDatumCtrl::OnCheckUpdateState(UINT wParam, LONG lParam)
{
	CString	str;
	GetWindowText(str);
	CCustomCtrl::OnCheckUpdateState(&str);
	return 0L;
}

LONG	CDatumCtrl::OnKalenderPopup(UINT wParam, LONG lParam)
{
	CString	str;
	BOOL	bOK = FALSE;
	CRect	rect;

	if (!Validate())
		return 0L;

	GetWindowText(str);
	GetWindowRect(rect);
	if (str.IsEmpty()) {
		CPulDate	date;
		date.SetToday();
		str = date.GetDate2();
	}

	CKalenderPopupDlg	dlg(&str, &bOK, rect.left, rect.bottom);
	
	dlg.DoModal();
	GetParent()->RedrawWindow();
	if (bOK)
		SetWindowText(str);
	
	str = m_OrigStr;
	SetFocus();
	m_OrigStr = str;
	return 0L;
}

LONG	CDatumCtrl::OnDoNotValidate(UINT wParam, LONG lParam)
{
	m_bVal = FALSE;
	return 0L;
}

void CDatumCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar == VK_DOWN)
		PostMessage(AM_KODPOPUP);
	
	CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CDatumCtrl::OnEnable(BOOL bEnable) 
{
	CEdit::OnEnable(bEnable);
	
	m_pButton->EnableWindow(bEnable);
}

void CDatumCtrl::OnShowWindow(BOOL bShow, UINT nStatus)
{
	CEdit::OnShowWindow(bShow, nStatus);

	if(m_pButton)
		m_pButton->ShowWindow(bShow);
}


/////////////////////////////////////////////////////////////////////////////
// CKalenderPopupDlg dialog


CKalenderPopupDlg::CKalenderPopupDlg(CString *pDate, BOOL *pbOK, int x, int y, CWnd* pParent /*=NULL*/)
	: CDialog(CKalenderPopupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CKalenderPopupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_bFirstTime = TRUE;
	m_pDate = pDate;
	m_pbOK	= pbOK;
	m_x		= x;
	m_y		= y;
	m_bOk	= true;
}


void CKalenderPopupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKalenderPopupDlg)
	DDX_Control(pDX, MC_IDC_KALENDER, m_Cal);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CKalenderPopupDlg, CDialog)
	//{{AFX_MSG_MAP(CKalenderPopupDlg)
	ON_NOTIFY(MCN_SELECT, MC_IDC_KALENDER, OnSelectDay)
	ON_NOTIFY(MCN_GETDAYSTATE, MC_IDC_KALENDER, OnGetdaystateKalender)
	//}}AFX_MSG_MAP
	ON_WM_WINDOWPOSCHANGING()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKalenderPopupDlg message handlers

BOOL CKalenderPopupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	WINDOWPLACEMENT	wpDlg, wpTmp, wpCal;
	GetWindowPlacement(&wpDlg);

	// Anpassare Dialogen efter storleken p kalendern
	m_Cal.SizeMinReq();
	m_Cal.GetWindowPlacement(&wpCal);
	int	nCalWidth	= wpCal.rcNormalPosition.right - wpCal.rcNormalPosition.left;
	int	nCalHeight	= wpCal.rcNormalPosition.bottom - wpCal.rcNormalPosition.top;
	wpDlg.rcNormalPosition.right	= wpDlg.rcNormalPosition.left + nCalWidth;
	wpDlg.rcNormalPosition.bottom	= wpDlg.rcNormalPosition.top + nCalHeight;

	//	Anpassar bredden p Dialogen
	wpTmp = wpDlg;
	wpDlg.rcNormalPosition.bottom	= m_y + wpDlg.rcNormalPosition.bottom - wpDlg.rcNormalPosition.top;
	wpDlg.rcNormalPosition.left		= m_x;
	wpDlg.rcNormalPosition.top		= m_y;
	wpDlg.rcNormalPosition.right	= m_x + wpTmp.rcNormalPosition.right - wpTmp.rcNormalPosition.left;
	int	y = wpDlg.rcNormalPosition.bottom-(GetSystemMetrics(SM_CYMAXIMIZED)-GetSystemMetrics(SM_CYBORDER));
	int	x = wpDlg.rcNormalPosition.right-(GetSystemMetrics(SM_CXMAXIMIZED)-GetSystemMetrics(SM_CXBORDER));
	if (y > 0) {
		wpDlg.rcNormalPosition.top		-= y;
		wpDlg.rcNormalPosition.bottom	-= y;
	}
	if (x > 0) {
		wpDlg.rcNormalPosition.left		-= x;
		wpDlg.rcNormalPosition.right	-= x;
	}

	VERIFY(SetWindowPlacement(&wpDlg) != 0);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CKalenderPopupDlg::OnWindowPosChanging(WINDOWPOS* lpwndpos)
{
	if (IsWindowVisible() && m_bOk) // Om m_bOk s har inte OnCancel skickat meddelandet,
									// om OnCancel krs dubbelt frsvinner fnstertiteln!
		CDialog::OnCancel();
}	


void CKalenderPopupDlg::OnSelectDay(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NMSELCHANGE	*pSel = (NMSELCHANGE *)pNMHDR;
	
	m_pDate->Format("%04d-%02d-%02d", 
		pSel->stSelStart.wYear,
		pSel->stSelStart.wMonth,
		pSel->stSelStart.wDay);
	
	*m_pbOK = TRUE;
//	*pResult = 0;
	m_bOk = false; // Stts fr att inte kra en extra OnCancel/OnOK genom OnWindowsPosChanging.
	CDialog::OnOK();
}


void CKalenderPopupDlg::OnGetdaystateKalender(NMHDR* pNMHDR, LRESULT* pResult) 
{
	if (m_bFirstTime) {
		m_bFirstTime = FALSE;

		SYSTEMTIME	st;
		st.wYear = atoi(m_pDate->Mid(0,4));
		st.wMonth = atoi(m_pDate->Mid(5,2));
		st.wDay = atoi(m_pDate->Mid(8,2));
		
		((CMonthCalCtrl *)GetDlgItem(MC_IDC_KALENDER))->SetCurSel(&st);
//		*pResult = 0;
	}

}



/////////////////////////////////////////////////////////////////////////////
// CKodPopupButton message map

BEGIN_MESSAGE_MAP(CKodPopupButton, CButton)
	//{{AFX_MSG_MAP(CKodPopupButton)
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	ON_WM_SETFOCUS()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CKodPopupButton::OnSetFocus(CWnd* pOldWnd) 
{
	CButton::OnSetFocus(pOldWnd);
	
	m_pEdit->SendMessage(AM_POPUPBUTTONPRESSED);
}

int CKodPopupButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CButton::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_pEdit->IsWindowEnabled())
		EnableWindow(FALSE);
	
	return 0;
}
