/*
 *	Filnamn:		CustomCtrl.h
 *	Syfte  :		Egendefinierade kontroller.
 *					Alla kontroller mste registreras innan anvndning, vilket 
 *					grs med funktionen RegisterControlClass fr respektive 
 *					kontroll.
 *
 *	Historik		
 *	1996-12-12, Ulf		Skapad
 *	1998-03-27	Magnus	Lagt till SetDocValue.
 *	1998-09-29	Ulf		Lagt till CManadEdit
 *	1999-02-27	Peter	Lagt till CTextEdit::GetFieldValueInt()
 *	1999-12-02	Magnus	Lagt till SetOrigStr.
 *	1999-12-04	Peter	ndrat i TidEdit frn CPulTime till CPulTimeDb
 *	2004-05-28	Malin	Lagt till #define CC_DROPLIST
 */
#ifndef	DEF_PULCUSTOMCTRL
#define	DEF_PULCUSTOMCTRL

#include "PulDate.h"

#define	CC_ID_FIELD			0x0001
#define	CC_NOCONFIRM		0x0002
#define	CC_NOT_BLANK		0x0004
#define	CC_DROPLIST			0x0008


#define	AM_GOODBYE						WM_USER+100		//	Avslut av bild
#define	AM_SCROLL_UP					WM_USER+101		//	Scrolla uppt
#define	AM_SCROLL_DOWN					WM_USER+102		//	Scrolla nedt
#define	AM_PAGE_UP						WM_USER+103		//	Blddra en sida bakt
#define	AM_PAGE_DOWN					WM_USER+104		//	Blddra en sida framt
#define	AM_POSITIONBYTHUMB				WM_USER+105		//	Scrollbarboxen har dragits
#define	AM_SETTHUMBPOSITION				WM_USER+106		//	ndra positionen p scrollbarboxen
#define	AM_NEW_SORTORDER				WM_USER+107		//	ndra sorteringordning
#define	AM_ID_CHANGED					WM_USER+108		//	CUSTOMCTRL: Nyckelfltet r ndrat
#define	AM_FIELD_UPDATED				WM_USER+109		//	CUSTOMCTRL: Fltet r ndrat
#define	AM_FIELD_CHANGED				WM_USER+110		//	CUSTOMCTRL: Varje gng ett flt frndras
#define	AM_ID_LOST_FOCUS				WM_USER+111		//	CUSTOMCTRL: Nyckelfltet har tappat focus
#define	AM_FIELD_LOST_FOCUS				WM_USER+112		//	CUSTOMCTRL: Fltet har tappat focus
#define	AM_VALIDATION_ERROR				WM_USER+113		//	CUSTOMCTRL: Felaktion inmatning i kontroll
#define	AM_EMPTY						WM_USER+114		//	CUSTOMCTRL: Tm kontrollen
#define	AM_DOC2VIEW						WM_USER+115		//	CUSTOMCTRL: Flyttar vrde frn 
														//				Doc-variabel -> View-variabel -> kontroll
#define	AM_VIEW2DOC						WM_USER+116		//	CUSTOMCTRL: Flyttar vrde frn 
														//				kontroll -> View-variabel -> Doc-variabel
#define	AM_SETKODTYP					WM_USER+117		//	Skickas till parent fr att stta kodtyp
#define	AM_VALIDATE						WM_USER+118		//	Skickas till Custom Ctrl fr att utfra validering
#define	AM_CHECK_UPDATE_STATE			WM_USER+119		//	Skickas till Custom Ctrl fr att testa om de
														//  har uppdaterats.
#define	AM_STATE_UPDATED				WM_USER+120		//	CUSTOMCTRL: Fltet r ndrat
#define	AM_ACTIVATE						WM_USER+121		//	Skickas vid aktivering/deaktivering av fnster
#define	AM_KODPOPUP						WM_USER+122		//	Skickas till KodEdit fr att aktiver kodpopup-fnster
#define	AM_UPDATE_ARENDE				WM_USER+123		// Skickas d rendeuppgifter behver uppdateras
#define	AM_DELETE_LISTCTRL_LINE			WM_USER+124		// Skickas d man trycker p delete-tangenten i en CPulListCtrl
#define	AM_UP_LISTCTRL_LINE				WM_USER+125		// Skickas d man trycker p pil upp-tangenten i en CPulListCtrl
#define	AM_DOWN_LISTCTRL_LINE			WM_USER+126		// Skickas d man trycker p pil ner-tangenten i en CPulListCtrl
#define	AM_HOME_LISTCTRL_LINE			WM_USER+127		// Skickas d man trycker p HOME-tangenten i en CPulListCtrl
#define	AM_END_LISTCTRL_LINE			WM_USER+128		// Skickas d man trycker p END-tangenten i en CPulListCtrl
#define	AM_UPDATE_TREE					WM_USER+129		// Skcikas d trdet behver uppdateras
#define	AM_UPDATE_UTBET					WM_USER+130		// Skickas d utbetalningsuppgifter behver uppdateras
#define	AM_UPDATE_AVGIFT				WM_USER+131		// Skickas d avgiftsuppgifter behver uppdateras
#define	AM_DONE							WM_USER+132		// Skickas till en specifik dialog d ngon krning i underhll r klar.
#define	AM_POPUPBUTTONPRESSED			WM_USER+133		// Skicka till kontrollen d man trycker p popuppilen
#define	AM_UPDATE						WM_USER+134		// Skickas till dialogen d innehllet i ett flt r frndrat motsv EN_UPDATE
#define	AM_DO_NOT_VALIDATE				WM_USER+135		// Skickas till den CC som ftt focus, frn en annan CC som ftt valideringsfel
#define	AM_QUIT							WM_USER+136		// Skickas till funktionen OnQuit fr att stnga ner bilden. Anvnds fr rttighetssystemet
#define	AM_CHANGESORT					WM_USER+137		// Skickas till frn listctrl till dlg nr man ndrar sorteringsording
#define	AM_GET_SUM						WM_USER+138		// Skickas till anropande bild frn kalkyler fr att verfra summan
#define	AM_UPDATE_BUTTONS				WM_USER+139		// Skickas till anropande bild frn kalkyler fr att verfra summan
#define	AM_GET_FILTER					WM_USER+140		// Skickas till anropande bild frn popuper fr att fr att lgga p WHERE-villkor popup-listan
#define	AM_FULLSCREEN_UPDATE			WM_USER+141		// Skickas till anropande bild frn fullscreenedit nr texten skall uppdateras
#define	AM_PARENT_UPDATE				WM_USER+142		// Skickas till aktuell bild som i sin tur uppdaterar tooltitexten fr MC_ID_PARENT (IFO)
#define	AM_THREADPRINTING_COMPLETE		WM_USER+143		// Skickas nr utskriften som krs i en egen trd har gtt klart
#define	AM_UPDATE_HEMVARDSBIDRAG		WM_USER+144		// Skickas d hemvrdsbidragsuppgifter behver uppdateras
#define AM_LOCKMC						WM_USER+145		// Skickas d skrmslckare i MagnaCura ska aktiveras
#define AM_QUIT2						WM_USER+146		// Skickas till funktionen OnQuit2()
#define AM_SHOW_MESSAGEDLG				WM_USER+147		// Skickas d meddelande har kommit och meddelandedialogen ska visas.
#define AM_QUIT_BOKNING					WM_USER+148		// Skickas till funktionen OnQuit i bilden fr ej kvitterade bokningar i IFO
#define AM_KOLLA_MEDD					WM_USER+149		// Skickas till Mainframe fr att kolla om nya meddelanden har kommit
#define AM_SAVE_SCAN					WM_USER+150		// Skickas fr att spara scannat dokument
#define AM_UGPERSNR_CHANGED				WM_USER+151		// Skickas nr et personnummer r frndrat i en UGGrid



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CCustomCtrl
//
//	Basklass fr alla egendefinierade kontroller
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
class CCustomCtrl
{
// Construction
public:
	CCustomCtrl();

// Attributes
public:
	enum			m_DocType { DOCSTRING, DOCSHORT, DOCINT, DOCLONG, DOCCSTRING };
	CCustomCtrl		*m_pCtrl;
	CWnd			*m_pParent;
	WORD			m_wCtrlID;
	WORD			m_wType;
	CString			*m_pViewValue;
	void			*m_pDocValue;
	CString			m_OrigStr;
	int				m_wRange;
	UINT			m_nFormatFlag;
	BOOL			m_bValidate;
	bool			m_bCString;

// Operations
public:
	void			SetRange(int wRange = 0)	{ m_wRange = wRange; }
	void			SetOrigStr(CString	str) { m_OrigStr = str;	}
	void			SetOrigStr(char	*str) { m_OrigStr = str;	}
	void			Init(CCustomCtrl	*pCtrl,
						 CWnd			*pParent, 
						 WORD			wCtrlID, 
						 int			wRange, 
						 CString		*pViewValue, 
						 void			*pDocValue=NULL, 
						 WORD			wType=0,
						 LPCSTR			lpszInitStr=NULL);
	void			OnChange(CString *pStr);
	void			OnKillfocus(CString *pStr);
	void			OnSetfocus(CString *pStr);
	CString			*OnEmpty();
	CString			*OnDocToView();
//	void			OnViewToDoc(CString *pStr);
	void			OnViewToDoc();
	void			OnValidate();
	void			OnCheckUpdateState(CString *pStr);
	BOOL			ValidationAllowed();
	void			OnError();

// Overrides
	virtual	int		GetFieldValue(LPSTR lpszDest);
	virtual	void	SetDocValue(void *pDocValue);
	virtual	BOOL	Validate()		{ return TRUE;}
	virtual	void	Format()		{;}
	virtual	void	FocusCtrl()		{;}

// Implementation
public:
	virtual ~CCustomCtrl();
};



/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDatumEdit window
//
//	Denna kontroll hanterar datum.
//	
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
class CDatumEdit : public CEdit, public CCustomCtrl
{
// Construction
public:
	CDatumEdit();
	static	BOOL	RegisterControlClass();										//	Obligatorisk
	BOOL			m_bVal;
	bool			m_bCheck;
	bool			m_bCPulDate2;

// Attributes
public:

// Operations
public:
	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDateDb		*pDocValue,		//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDate2		*pDocValue,		//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue);			//	Pekare till CString (View-variabel)

	void			Exchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDateDb		*psDocValue=NULL,		//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			Exchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDate2		*psDocValue=NULL,		//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			Exchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CString			*psDocValue,			//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

// Overrides
	virtual	BOOL	Validate();
	virtual	void	Format();
	virtual	int		GetFieldValue(CPulDateDb *pDest);
	virtual	int		GetFieldValue(CPulDate2 *pDest);
	virtual	int		GetFieldValue(LPSTR lpszDest);
	virtual	void	FocusCtrl()		{ SetFocus(); }

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDatumEdit)
	protected:
	virtual void	PostNcDestroy()	{ delete this; }							//	Obligatirisk
	//}}AFX_VIRTUAL
	static	LRESULT CALLBACK EXPORT	WndProcHook(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);	// Obligatirks
	static	WNDPROC					lpfnWndProc;								// Obligatorisk

// Implementation
public:
	virtual ~CDatumEdit();

	// Generated message map functions
protected:
	//{{AFX_MSG(CDatumEdit)
	afx_msg void OnChange();
	afx_msg void OnKillfocus();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetfocus();
	//}}AFX_MSG
	LONG			OnEmpty(UINT wParam, LONG lParam);
	LONG			OnDocToView(UINT wParam, LONG lParam);
	LONG			OnViewToDoc(UINT wParam, LONG lParam);
	LONG			OnValidate(UINT wParam, LONG lParam);
	LONG			OnCheckUpdateState(UINT wParam, LONG lParam);
	LONG			OnDoNotValidate(UINT wParam, LONG lParam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

#endif
