/*
 *	Filnamn:		PulCustomCtrl.cpp
 *	Syfte  :		Egendefinierade kontroller
 *					Alla kontroller mste registreras innan anvndning, vilket 
 *					grs med funktionen RegisterControlClass fr respektive 
 *					kontroll.
 *
 *	Historik		
 *	1996-12-12, Ulf			Skapad
 *	1997-02-22, Peter		PersnrEdit.Validate() godknner personnummer med nollor i de
 *							tv frsta positionerna i siffrorna efter datumet.
 *	1998-03-27	Magnus		Lagt till SetDocValue
 *	1998-09-29	Ulf			Lagt till CManadEdit
 *	1999-02-19	AndersP		Fixat felaktig lngdberkning p CNumEdit nr "-" anvnds
 *	1999-02-27	Peter		Lagt till CTextEdit::GetFieldValueInt()
 *	1999-12-04	Peter		ndrat i TidEdit frn CPulTime till CPulTimeDb
 *	2000-03-05	Peter		Rttat fel vid inskrivning av tid, om man skrev 12.30 blev tiden 12:00
 *	2000-04-01	Peter		Rttat fel vid hanteirng av postnummer och tillgg av mellanslag automatiskt
 *							(blir fortfarande fel att hopp sker till nsta flt vid 5 tecken)
 *	2000-05-09	Pernill		Anpassat PostnrEdit till IFO
 *	2000-06-11	Peter		Tillter personnummer med datum 50-81 fr tillflliga personnummer enl skattemyndigheten
 *	2001-03-29	David/Ulf	Bytt kollen p datumfltet fr invandrare frn 5 till 6
 *	2001-07-09	Mikael		Lagt kontroll och formatering av personnr i extern funktion i ChechNr.cpp
 *	2003-01-20	David		Tagt bort kod i ValidationAllowed eftersom det gav dykningar vid skning p gemensam huvudbild
 *	2003-07-17	Peter		Rttat fel i CNumEdit::Validate() som gjorde att det inte fungerade med 1 decimal
 *  2003-10-09  Pernilla	Tog bort en IFO define eftersom den inte fungerade
 *	2004-12-14	Peter (Malin) Lagt till s att m_OrigStr = (LPSTR)m_pDocValue i CCustomCtrl::OnDoc2View() 
 *	2005-11-06	Peter		Lagt till specialhantering fr att kunna ange kvartal i mnadsflt (fr statistik)
 *	2006-02-16	Peter		Lagt till en special fr att kunna ange fiktiva personnummer som brjar med "--"
 *	2007-03-11	Peter		Anpassat CDatumEdit::OnDocToView() fr att visa olika datumformat beroende p lngden p fltet
 *	2007-05-12	Peter		Rttat CPostnrEdit::Validate s att inte femstlligt postnr med mellanslag godknns, 
 *							finns mellanslag r det sex tecken
 */
#include "stdafx.h"
#if _MFC_VER < 0x0700
#include <ctl3d.h>
#endif
#include <locale.h>
#include "PulDate.h"
//#include "Message.h"
//#include "UsefulFuncs.h"
//#include "CheckNr.h"
#include "PulCustomCtrl.h"




/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CCustomCtrl
//
//	Basklass fr alla egendefinierade kontroller
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
CCustomCtrl::CCustomCtrl()
{
	m_pCtrl			= NULL;
	m_pParent		= NULL;
	m_wCtrlID		= 0;
	m_wType			= 0;
	m_pViewValue	= NULL;
	m_pDocValue		= NULL;
	m_OrigStr		= _T("");
	m_wRange		= 0;
	m_nFormatFlag	= FALSE;
	m_bValidate		= TRUE;
	m_bCString		= false;
}

CCustomCtrl::~CCustomCtrl()
{
}

void	CCustomCtrl::Init(CCustomCtrl	*pCtrl,
						  CWnd			*pParent, 
						  WORD			wCtrlID, 
						  int			wRange, 
						  CString		*pViewValue, 
						  void			*pDocValue, 
						  WORD			wType,
						  LPCSTR		lpszInitStr)
{
	m_pCtrl				= pCtrl;
	m_pParent			= pParent;
	m_wCtrlID			= wCtrlID;
	SetRange(wRange);
	m_pViewValue		= pViewValue;
	*m_pViewValue		= _T("");
	m_pDocValue			= pDocValue;
	m_wType				= wType;
	if (lpszInitStr)
		m_pViewValue->Format("%s", lpszInitStr);
}

int	CCustomCtrl::GetFieldValue(LPSTR lpszDest)
{
	if (lpszDest == NULL)
		return 0;
	*lpszDest = 0;
	return 0;
}

/*
 *	1998-03-27	Magnus
 *	
 *	Funktion fr att stta om pekaren till docvalue, kan vara anvndbar t ex om
 *	man anvnder en lnkad lista.
 *
 *	Indata:	pDocValue Den nya pekaren till docvalue
 *
 */
void	CCustomCtrl::SetDocValue(void *pDocValue)
{
	m_pDocValue = pDocValue;
}

void CCustomCtrl::OnChange(CString *pStr)
{
	if (m_nFormatFlag) {
		m_nFormatFlag = FALSE;
	}
	else if (!pStr->IsEmpty() && m_wType & CC_NOCONFIRM && Validate()) 
		((CDialog*)m_pParent)->NextDlgCtrl();

	m_pParent->SendMessage(AM_FIELD_CHANGED, m_wCtrlID);
}


void CCustomCtrl::OnKillfocus(CString *pStr)  
{
	if (pStr->IsEmpty()) {
		if (m_wType & CC_NOT_BLANK) {
//			m_pCtrl->FocusCtrl();
//			m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
			OnError();
		}
		else if (*pStr == m_OrigStr) {
			if (m_wType & CC_ID_FIELD)
				m_pParent->SendMessage(AM_ID_LOST_FOCUS, m_wCtrlID);
			else 
				m_pParent->SendMessage(AM_FIELD_LOST_FOCUS, m_wCtrlID);
		}
		else {
			if (m_wType & CC_ID_FIELD)
				m_pParent->SendMessage(AM_ID_CHANGED, m_wCtrlID);
			else
				m_pParent->SendMessage(AM_FIELD_UPDATED, m_wCtrlID);
		}
	}
	else if (!m_pCtrl->Validate()) {
//		m_pCtrl->FocusCtrl();
//		m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
		OnError();
	}
	else if (*pStr == m_OrigStr) {
		m_pCtrl->Format();
		if (m_wType & CC_ID_FIELD)
			m_pParent->SendMessage(AM_ID_LOST_FOCUS, m_wCtrlID);
		else 
			m_pParent->SendMessage(AM_FIELD_LOST_FOCUS, m_wCtrlID);
	}
	else {
		m_pCtrl->Format();
		if (m_wType & CC_ID_FIELD)
			m_pParent->SendMessage(AM_ID_CHANGED, m_wCtrlID);
		else
			m_pParent->SendMessage(AM_FIELD_UPDATED, m_wCtrlID);
	}
}

void CCustomCtrl::OnSetfocus(CString *pStr) 
{
	m_OrigStr = *pStr; 
}


CString *CCustomCtrl::OnEmpty()
{
	m_pViewValue->Empty();
	return m_pViewValue;
}

CString *CCustomCtrl::OnDocToView()
{
	if (m_pDocValue) {
		if	(m_bCString) {
			*m_pViewValue = *((CString*)m_pDocValue);
			m_OrigStr = *((CString*)m_pDocValue); 
		}
		else {
			*m_pViewValue = (LPSTR)m_pDocValue;
			m_OrigStr = (LPSTR)m_pDocValue; 
		}
		return m_pViewValue;
	}
	return NULL;
}

void	CCustomCtrl::OnViewToDoc()
{
	if (m_pDocValue) {
		if	(m_bCString)
			*(CString*)m_pDocValue = *m_pViewValue;
		else
			strcpy((LPSTR)m_pDocValue, *m_pViewValue);
	}
}

void	CCustomCtrl::OnValidate()
{
	if (!m_pCtrl->Validate()) {
		OnError();
		m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
	}
}

void	CCustomCtrl::OnCheckUpdateState(CString *pStr)
{
	if (pStr && m_pViewValue && *pStr != *m_pViewValue)
		m_pParent->SendMessage(AM_STATE_UPDATED, m_wCtrlID);
}

BOOL	CCustomCtrl::ValidationAllowed()
{
	CWnd	*pwndFocus = m_pParent->GetFocus();
	int		nIDFocus = pwndFocus == NULL ? 0 :pwndFocus->GetDlgCtrlID();
	CWnd	*pWnd;

	if (nIDFocus == 0 || 
		nIDFocus == 2 ||		// IDCANCEL
		//Detta id krockar i nulget med en kryssruta i HO, men det gr inte att 
		//Lgga en IFO define hr //Pernilla
		nIDFocus == 34661 ||	// ID_LISTA_IFOKODER	(Fr att man skall kunna lista koder
		nIDFocus == 48833 ||	// MC_ID_LISTA_IFOKODER	 utan att fylla i nn kod)
		nIDFocus == 48871 ||	// ID_CANCEL
		nIDFocus == 48801)		// MC_IDCANCEL
		return FALSE;

//Tagit bort detta stycke 030120 eftersom det ger dykningar /David

//	if (m_pParent->IsKindOf(RUNTIME_CLASS(CMCPropertyPage))) {
//		pWnd = m_pParent->GetParent();
///*		int	nPropId = ((CMCPropertySheet*)pWnd)->GetPageIndex((CMCPropertyPage*)m_pParent);
//		int	nCurTab = ((CMCPropertySheet*)pWnd)->GetTabControl()->GetCurSel();
//		if (nPropId != nCurTab && nCurTab != -1) {
//			((CMCPropertySheet*)pWnd)->SetActivePage((CMCPropertyPage*)m_pParent);
//			return TRUE;
//		}  */
//		int		i = 0;
//		while(i++ < 10 && !pWnd->IsKindOf(RUNTIME_CLASS(CMCFormView)))
//			pWnd = pWnd->GetParent();
//		if (pWnd->IsKindOf(RUNTIME_CLASS(CMCFormView))) {
////			return (pWnd->GetDescendantWindow(nIDFocus) != NULL);
//			CWnd *pTmpWnd = pWnd->GetDescendantWindow(nIDFocus);
//			if (pTmpWnd == NULL)
//				return FALSE;
//			pwndFocus->SendMessage(AM_DO_NOT_VALIDATE);
//			return TRUE;
//		}
//	}
	pWnd = m_pParent->GetDescendantWindow(nIDFocus);
	if (pWnd == NULL)
		return FALSE;
	pwndFocus->SendMessage(AM_DO_NOT_VALIDATE);
	return TRUE;
}

void	CCustomCtrl::OnError()
{
	if (ValidationAllowed()) {
		m_pParent->GetDlgItem(m_wCtrlID)->SetFocus();
//		m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
	}
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDatumEdit window
//
//	Denna kontroll hanterar datum.
//	
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
CDatumEdit::CDatumEdit()
{
//	m_bVal = false;
	m_bCheck = false;
	m_bCPulDate2 = false;
}

CDatumEdit::~CDatumEdit()
{
}

void	CDatumEdit::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDateDb		*pDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, pDocValue, wType, lpszInitStr);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

void	CDatumEdit::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDate2		*pDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	m_bCPulDate2 = true;
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, pDocValue, wType, lpszInitStr);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

void	CDatumEdit::InitAndDataExchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue) 
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, NULL, 0, NULL);

	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange)
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
}

void	CDatumEdit::Exchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDateDb		*psDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, psDocValue, wType, lpszInitStr);
	
	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange){
		m_pViewValue->Remove('-');		
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
	}
}

void	CDatumEdit::Exchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CPulDate2		*psDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, psDocValue, wType, lpszInitStr);
	
	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange){
		m_pViewValue->Remove('-');		
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
	}
}

void	CDatumEdit::Exchange(CDataExchange	*pDX,  
										 WORD			wCtrlID, 
										 WORD			wRange, 
										 CString		*pViewValue, 
										 CString		*psDocValue, 
										 WORD			wType, 
										 LPCSTR			lpszInitStr)
{ 
	if (!m_pViewValue)  // Frsta gngen ej initierad
		Init(this, pDX->m_pDlgWnd, wCtrlID, wRange, pViewValue, psDocValue, wType, lpszInitStr);
	
	DDX_Text(pDX, m_wCtrlID, *m_pViewValue); 
	if (m_wRange){
		m_pViewValue->Remove('-');		
		DDV_MaxChars(pDX, *m_pViewValue, m_wRange);
	}
}

#define	digit_sum(nr)	((nr) > 9 ? 1+(nr) : (nr))
#define	ctoi(nr)		((nr) - '0')

/////////////////////////////////////////////////////////////////////////////
// Validate
//		Denna medlemsfunktion kontrollerar om det r ett korrekt personnummer.
//	
//	Returvrde:
//		Returnerar TRUE om det r ett korrekt personnummer, annars FALSE
//
//	Anmrkning:
//		Korrekta personnummer:
//			MMDDXXXX
//			MMDD-XXXX
//			MMDDXXXX
//			MMDD-XXXX
//		Den kontrollerar ocks att det r rtt checksiffra.
//
BOOL	CDatumEdit::Validate()
{
	CString		str;
	CPulDate	date;

	GetWindowText(str);
	date.SetDate(str);
	
	if (!str.IsEmpty() && date.IsEmpty())
		return FALSE;

	return date.IsValid();
}


/////////////////////////////////////////////////////////////////////////////
// Format
//		Denna medlemsfunktion formatterar editfltets personnummer till 
//		utseendet MMDD-XXXX.
//		Det frutstts att personnumret r korrekt (se Validate).
//	
void	CDatumEdit::Format()
{
	CString		str;
	CPulDate	date;

	GetWindowText(str);
	date.SetDate(str);
	date.SetCentury();

	m_nFormatFlag = TRUE;
	str = date;
	SetWindowText(str);
}

int	CDatumEdit::GetFieldValue(CPulDateDb *pDest)
{
	if (pDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	pDest->SetDate(str);
	return str.GetLength();
}

int	CDatumEdit::GetFieldValue(CPulDate2 *pDest)
{
	if (pDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	pDest->SetDate(str);
	return str.GetLength();
}

int	CDatumEdit::GetFieldValue(LPSTR lpszDest)
{
	if (lpszDest == NULL)
		return 0;
	CString	str;
	GetWindowText(str);
	strcpy((LPSTR)lpszDest, str);
	return str.GetLength();
}


LRESULT CALLBACK EXPORT	CDatumEdit::WndProcHook(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	CDatumEdit	*pEdit = new CDatumEdit();
	pEdit->Attach(hWnd);
	pEdit->m_pfnSuper = lpfnWndProc;
	SetWindowLong(hWnd, GWL_WNDPROC, (DWORD)AfxWndProc);
#if _MFC_VER < 0x0700
#ifndef _MAC
	pEdit->SubclassCtl3d(CTL3D_EDIT_CTL);
#endif
#endif
#ifdef STRICT
	return CallWindowProc(AfxWndProc, hWnd, msg, wParam, lParam);
#else
	return CallWindowProc((FARPROC)AfxWndProc, hWnd, msg, wParam, lParam);
#endif
}


WNDPROC	CDatumEdit::lpfnWndProc = NULL;

BOOL	CDatumEdit::RegisterControlClass()
{
	WNDCLASS	wc;

	static const TCHAR	lpszClassName[] = _T("DatumEdit");
	if (GetClassInfo(AfxGetInstanceHandle(), lpszClassName, &wc)) 
		return (wc.lpfnWndProc == (WNDPROC)WndProcHook); // Redan registrerad
	
	// Anvnd "edit" som template
	GetClassInfo(NULL, _T("edit"), &wc);
	lpfnWndProc = wc.lpfnWndProc;

	// Lgger in de nya vrdena
	wc.lpfnWndProc		= WndProcHook;
	wc.hInstance		= AfxGetInstanceHandle();
	wc.lpszClassName	= lpszClassName;
	return (RegisterClass(&wc) != 0);
}



BEGIN_MESSAGE_MAP(CDatumEdit, CEdit)
	//{{AFX_MSG_MAP(CDatumEdit)
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_WM_CHAR()
	ON_CONTROL_REFLECT(EN_SETFOCUS, OnSetfocus)
	//}}AFX_MSG_MAP
	ON_MESSAGE(AM_EMPTY, OnEmpty)
	ON_MESSAGE(AM_DOC2VIEW, OnDocToView)
	ON_MESSAGE(AM_VIEW2DOC, OnViewToDoc)
	ON_MESSAGE(AM_VALIDATE, OnValidate)
	ON_MESSAGE(AM_CHECK_UPDATE_STATE, OnCheckUpdateState)
	ON_MESSAGE(AM_DO_NOT_VALIDATE, OnDoNotValidate)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDatumEdit message handlers

void CDatumEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if (nChar != '-' && IsCharAlpha((TCHAR)nChar))
		return;
	CEdit::OnChar(nChar, nRepCnt, nFlags);
}

void CDatumEdit::OnChange() 
{
	CString		str;	
	GetWindowText(str);
	CCustomCtrl::OnChange(&str);
	m_pParent->SendMessage(EN_CHANGE);
}

void CDatumEdit::OnKillfocus() 
{
/*	if (!m_bVal) {
		m_bVal = TRUE;
		return;
	}*/
	CString		str;	
	GetWindowText(str);
	CCustomCtrl::OnKillfocus(&str);
	m_pParent->SendMessage(EN_KILLFOCUS);
}


void CDatumEdit::OnSetfocus() 
{
	m_bVal = TRUE;
	CString	str;
	GetWindowText(str);
	CCustomCtrl::OnSetfocus(&str);
	m_pParent->SendMessage(EN_SETFOCUS);
}

LONG	CDatumEdit::OnEmpty(UINT wParam, LONG lParam)
{
	SetWindowText(*CCustomCtrl::OnEmpty());
	return 0L;
}

LONG	CDatumEdit::OnDocToView(UINT wParam, LONG lParam)
{
	
	if (m_pDocValue) 
	{
		if (m_wRange > 8)	//	Har tyvrr inte access till vra define i detta lget
		{
			if (m_bCPulDate2)
				*m_pViewValue = ((CPulDate2*)m_pDocValue)->GetDate2();
			else
				*m_pViewValue = ((CPulDate*)m_pDocValue)->GetDate2();
		}
		else if (m_wRange > 6)
		{
			if (m_bCPulDate2)
				*m_pViewValue = ((CPulDate2*)m_pDocValue)->GetDate();
			else
				*m_pViewValue = ((CPulDate*)m_pDocValue)->GetDate();
		}
		else if (m_wRange == 6)
		{
			if (m_bCPulDate2)
				*m_pViewValue = ((CPulDate2*)m_pDocValue)->GetDate6();
			else
				*m_pViewValue = ((CPulDate*)m_pDocValue)->GetDate6();
		}
	}
	
	return 0L;
}

LONG	CDatumEdit::OnViewToDoc(UINT wParam, LONG lParam)
{
	if (m_pDocValue) {
		CString	str;
		GetWindowText(str);
		if (!Validate()) 
			OnError();
//			m_pParent->SendMessage(AM_VALIDATION_ERROR, m_wCtrlID);
		else {
			Format();
			GetWindowText(*m_pViewValue);
			if (m_bCPulDate2)
				*((CPulDate2*)m_pDocValue) = *m_pViewValue;
			else
				*((CPulDate*)m_pDocValue) = *m_pViewValue;
		}
	}
	return 0L;
}

LONG	CDatumEdit::OnValidate(UINT wParam, LONG lParam)
{
	CString	str;
	GetWindowText(str);
	if (str.IsEmpty() && (m_wType & CC_NOT_BLANK)) {
		OnError();
		return 0L;
	}
	CCustomCtrl::OnValidate();
	return 0L;
}

LONG	CDatumEdit::OnCheckUpdateState(UINT wParam, LONG lParam)
{
	CString	str;
	GetWindowText(str);
	CCustomCtrl::OnCheckUpdateState(&str);
	return 0L;
}

LONG	CDatumEdit::OnDoNotValidate(UINT wParam, LONG lParam)
{
	m_bVal = FALSE;
	return 0L;
}
