/*
 *	Filnamn:		CPulDate.h
 *	Syfte  :		Funktioner och classer fr att hantera datum
 *
 *	Historik		
 *	961219, UL		Skapad
 *	970223, PK		Lagt till GetAsLong(), SetFromLong()
 *	970511, PK		Lagt till GetDate2()
 *	970831, PK		Lagt till <, <=, > och >= i CPulDateDb
 *	971120, PK		Lagt till IsEmpty() i CPulDateDb
 *	980610, PK		Lagt till GetDate6()
 *	1998-07-29	Ulf		Nya funktioner AddWeekDay och DayOfWeek
 *	1998-11-29	PK		Lagt till !=
 *	1999-02-28	Peter	Lagt till ngra funktioner samt ndrat s att Add... returnerar this
 *	1999-03-08	Peter	ndrat returvrde p SetCentury() till CPulDateDb&
 *	1999-04-10	Peter	Tagit bort CPulDatePeriod och slagit ihop den med CPulPeriod
 *	1999-04-11	Peter	Lgt till funktioner fr hantering av veckonr
 *	1999-06-26	Peter	Lagt till GetMonth4(), GetYear() och GetMonthStr() fr CPulMonthDb
 *	1999-07-04	Peter	Lagt till CPulMonthDb::operator-
 *						Lagt till CPulMonthDb::DateInMonth
 *	1999-09-18	Peter	Lagt till CPulDateDb::GetDayStr
 *	2000-02-24	Ulf		Typekonvertering CPulDate = CTime
 *	2003-11-25	Malin	Lagt till CPulDateDb::SameMonth(CString sDate), kontrollerar om sDate r datum i samma r, mnad.
 *	2005-02-24	Ulf		Lagt till CPulDate2 och CPulMonth2
 *	2005-11-05	Peter	Lagt till specialhantering av CPulMonth fr ackmulerade perioder och kvartal
 *	2006-07-01	Peter	Lagt till CPulMonthDb::GetPeriod()
 *	2007-02-06	Peter	Lagt till CPulDateDb::GetToday() fr f dagens datum utan att behva ha en instans av CPulDateDb
 */
#ifndef DEF_PULDATE
#define DEF_PULDATE

#include "afxdb.h"

class CPulMonth2;
class CPulDateDb;
class CPulDate;

// Initieringsvrden fr CPulDate2 och CPulTime2
#define	MC_DATETIME_YEAR_INIT		100
#define	MC_DATETIME_MONTH_INIT		1
#define	MC_DATETIME_DAY_INIT		1
#define	MC_DATETIME_HOUR_INIT		0
#define	MC_DATETIME_MINUTE_INIT		0
#define	MC_DATETIME_SECOND_INIT		0

class CPulDate2 : public COleDateTime
{
public:
	CPulDate2()	{ Init(); };
	CPulDate2(int Year, int Month, int Day);

	CPulDate2&			AddYear(int wYears);
	CPulDate2&			AddMonth(int wMonths);
	CPulDate2&			AddDay(int wDays);
	CPulDate2&			AddWeeksAndDays(int nVeckor, int nDagar);
	operator			CString()	{ return GetDate(); };	// tillter typkonvertering frn CPulDate2 till CString
	operator			CPulDate();
	int					DayOfWeek();						// Returnerar aktuell veckodag 1=Sndag, 2=Mndag, ... 7=Lrdag
	CString				GetDate();							// MMDD
	CString				GetDate2();							// -MM-DD
	CString				GetDate6();							// MMDD
	CString				GetDayStr(int nDay = 0);			// Dagens namn som strng, om 0 aktuellt datum
	int					GetWeekNr();						// Veckonummer
	void				Init();
	bool				IsEmpty();
	BOOL				IsValid();	
	CPulDate2&			operator=(const CPulDate2 Date);	// CPulDate2 = CPulDate2
	CPulDate2&			operator=(const CPulMonth2 Month);	// CPulDate2 = CPulMonth2
	CPulDate2&			operator=(const CPulDateDb Date);	// CPulDate2 = CPulDateDb
	CPulDate2&			operator=(const CTime Date);		// CPulDate2 = CTime
	CPulDate2&			operator=(const CString Date);		// CPulDate2 = CString
	CPulDate2&			operator=(LPCSTR lpszDate);			// CPulDate2 = char *
	CPulDate2&			operator++();						// ++CPulDate2
	CPulDate2&			operator++(int i);					// CPulDate2++
	CPulDate2&			operator--();						// --CPulDate2
	CPulDate2&			operator--(int i);					// CPulDate2--
	int					operator==(const CPulDate2 &date2);
	int					operator!=(const CPulDate2 &date2);
	int					operator<(const CPulDate2 &date2);
	int					operator<=(const CPulDate2 &date2);
	int					operator>(const CPulDate2 &date2);
	int					operator>=(const CPulDate2 &date2);
	long				operator-(const CPulDate2& Date);	// CPulDate2 - CPulDate2
	int					operator==(const CPulDateDb &date2);
	int					operator!=(const CPulDateDb &date2);
	int					operator<(const CPulDateDb &date2);
	int					operator<=(const CPulDateDb &date2);
	int					operator>(const CPulDateDb &date2);
	int					operator>=(const CPulDateDb &date2);
	long				operator-(const CPulDateDb& Date);
	bool				SameMonth(CString sDate);			// Anger om sDate har samma r, mnad som klassens datum.
	CPulDate2&			SetDate(CString Date);
	CPulDate2&			SetDate(int Year, int weeknr);
	CPulDate2			&SetFirstMondayOfYear(int Year);	// Frsta mndagen under ret
	CPulDate2&			SetFromJulianDate(long lJulian);
	CPulDate2&			SetLastDayOfMonth();
	CPulDate2&			SetToday();
	long				ToJulianDate();
};



typedef struct {
	BYTE	Day;
	BYTE	Month;
	WORD	Year;
} DWORD_DATE;


#define	DAYNO_SUNDAY	1
#define	DAYNO_MONDAY	2
#define	DAYNO_TUESDAY	3
#define	DAYNO_WEDNESDAY	4
#define	DAYNO_THURSDAY	5
#define	DAYNO_FRIDAY	6
#define	DAYNO_SATURDAY	7

class CPulDateDb
{
public:
	DWORD_DATE			m_dwDate;

	static CPulDateDb	GetToday();	//	Returnerar dagens datum utan att man behver ha ngon instans av CPulDateDb

	CString				GetDate();	// MMDD
	CString				GetDate2();	// -MM-DD
	CString				GetDate6();	// MMDD

	void				Init()		{ m_dwDate.Day = 0; m_dwDate.Month = 0; m_dwDate.Year = 0;};
	bool				IsEmpty()	{ return m_dwDate.Day == 0 && m_dwDate.Month == 0 && m_dwDate.Year == 0; };
	int					operator==(const CPulDateDb &date2);
	int					operator!=(const CPulDateDb &date2);
	int					operator<(const CPulDateDb &date2);
	int					operator<=(const CPulDateDb &date2);
	int					operator>(const CPulDateDb &date2);
	int					operator>=(const CPulDateDb &date2);
	CPulDateDb&			operator++();						// ++CPulDate
	CPulDateDb&			operator++(int i);					// CPulDate++
	CPulDateDb&			operator--();						// --CPulDate
	CPulDateDb&			operator--(int i);					// CPulDate--
	long				operator-(const CPulDateDb& Date);	// CPulDate - CPulDate
	long				ToJulianDate();
	CPulDateDb&			SetFromJulianDate(long lJulian);
	BOOL				IsValid();	
	CPulDateDb&			SetCentury();
	CPulDateDb&			SetDate(CString Date);
	CPulDateDb&			SetToday();
	CPulDateDb&			SetLastDayOfMonth();
	CPulDateDb&			SetFirstDayOfMonth();
	CPulDateDb&			AddYear(int wYears);
	CPulDateDb&			AddMonth(int wMonths);
	CPulDateDb&			AddDay(int wDays);
	CPulDateDb&			AddWeeksAndDays(int nVeckor, int nDagar);
	int					DayOfWeek();						// Returnerar aktuell veckodag 1=Sndag, 2=Mndag, ... 7=Lrdag
	CString				GetDayStr(int nDay = 0);			// Dagens namn som strng, om 0 aktuellt datum
	CPulDateDb			&SetFirstMondayOfYear(int year);	// Frsta mndagen under ret
	int					GetWeekNr();						// Veckonummer
	CPulDateDb&			SetDate(int year, int weeknr);
	long				GetAsLong();						// Br ej anvndas, krvs fr att CPulDate inte accepteras
	void				SetFromLong(long datum);			// som del av union
	bool				SameMonth(CString sDate);			// Anger om sDate har samma r, mnad som klassens datum.

	// Operatorverlagring
	operator			CString()	{ return GetDate(); }	// tillter typkonvertering frn CPulDate till CString
};

class CPulDate : public CPulDateDb
{
public :
	CPulDate()	{ memset(&m_dwDate, 0, sizeof(DWORD)); }
	CPulDate(int year, int month, int day)	{ m_dwDate.Year = year; m_dwDate.Month = month; m_dwDate.Day = day; };

public:
	// Medlemsfunktioner
	CPulDate&			operator=(const CPulDate Date);		// CPulDate = CPulDate
	CPulDate&			operator=(const CPulDate2 Date);	// CPulDate = CPulDate2
	CPulDate&			operator=(const CString Date);		// CPulDate = CString
	CPulDate&			operator=(LPCSTR lpszDate);			// CPulDate = char *
	CPulDate&			operator=(const CTime Date);		// CPulDate = CTime
};



/********************************************************************************/
/*																				*/
/*	Mnad																		*/
/*																				*/
/********************************************************************************/

class CPulMonth2 : public COleDateTime
{
public :
	CPulMonth2()								{ Init(); };
	CPulMonth2(CPulDate2 &d)					{ CString str; str.Format("%04d%02d01", d.GetYear(), d.GetMonth()); SetMonth(str); };

public:
	// Medlemsfunktioner
	CString				GetMonth();		// MM
	CString				GetMonth4();	// MM
	const char			*GetMonthStr();

	void				Init();
	bool				IsEmpty()				{ CPulDate2 d; d = *this; return d.IsEmpty(); };
	BOOL				IsValid();	
	CPulMonth2&			SetMonth(CString Month);
	CPulMonth2&			SetThisMonth();
	CPulMonth2&			AddYear(int wYears)		{ CPulDate2 d; d = *this; d.AddYear(wYears); return *this = d; };
	CPulMonth2&			AddMonth(int wMonths)	{ CPulDate2 d; d = *this; d.AddMonth(wMonths); return *this = d; };
	int					GetNrDays();						// antal dagar i en mnad
	BOOL				DateInMonth(const CPulDate2 &date)		{ return GetYear() == date.GetYear() && GetMonth() == date.GetMonth(); };

	// Operatorverlagring
	int					operator==(const CPulMonth2 &month2);
	int					operator!=(const CPulMonth2 &month2);
	int					operator<(const CPulMonth2 &dmonth2);
	int					operator<=(const CPulMonth2 &month2);
	int					operator>(const CPulMonth2 &month2);
	int					operator>=(const CPulMonth2 &month2);
	CPulMonth2&			operator++();						// ++CPulMonth2
	CPulMonth2&			operator++(int i);					// CPulMonth2++
	CPulMonth2&			operator--();						// --CPulMonth2
	CPulMonth2&			operator--(int i);					// CPulMonth2--
	long				operator-(const CPulMonth2& Month);// CPulMonth2 - CPulMonth2
	operator			CString()	{ return GetMonth(); }	// tillter typkonvertering frn CPulMonth till CString
	operator			CPulDate()	{ return CPulDate(GetYear(), ((COleDateTime*)this)->GetMonth(), GetDay()); };
	CPulMonth2&			operator=(const CPulMonth2 Month);		// CPulMonth2 = CPulMonth2
	CPulMonth2&			operator=(const CPulDate2 Date);		// CPulMonth2 = CPulDate2
	CPulMonth2&			operator=(const CTime Month);		// CPulMonth2 = CTime
	CPulMonth2&			operator=(const CString Month);			// CPulMonth2 = CString
	CPulMonth2&			operator=(LPCSTR lpszMonth);			// CPulMonth2 = char *
};


//
//	Mnad sparas med lite specialregler avseende kvartal och ackumulerade vrden fr flera mnader.
//	Detta anvnds primrt i statistiken.
//
//	manad sparas som vanligt mnad dr perioden avser den aktualla mnaden
//	manad sparas med +20 i mnad dr perioden avser hela tiden frn rsskiftet fram till och med aktuell mnad
//	manad sparas med +40 fr kvartal
//	T ex
//	mnad 03		enbart mars
//	mnad 23		perioden jan - mars
//					som specialfall gller att mnad 12 r totalen fr hela ret
//	mnad 41		frsta kvartalet (jan - mars), mnad kan endast ha vrdena 41, 42, 43 och 44
//

class CPulMonthDb
{
public:
	DWORD_DATE			m_dwMonth;

	CString				GetMonth();		// MM
	CString				GetMonth4();	// MM
	const char			*GetMonthStr();
	CString				GetPeriod();	// MMDD - MMDD
	CString				GetPeriod2();	// -MM-DD - -MM-DD
	CString				GetPeriod6();	// MMDD - MMDD
	int					GetYear()	{ return m_dwMonth.Year;		};

	void				Init()		{ m_dwMonth.Day = 1; m_dwMonth.Month = 0; m_dwMonth.Year = 0;};
	bool				IsEmpty()	{ return m_dwMonth.Month == 0 && m_dwMonth.Year == 0; };
	int					operator==(const CPulMonthDb &month2);
	int					operator!=(const CPulMonthDb &month2);
	int					operator<(const CPulMonthDb &dmonth2);
	int					operator<=(const CPulMonthDb &month2);
	int					operator>(const CPulMonthDb &month2);
	int					operator>=(const CPulMonthDb &month2);
	CPulMonthDb&		operator++();						// ++CPulMonth
	CPulMonthDb&		operator++(int i);					// CPulMonth++
	CPulMonthDb&		operator--();						// --CPulMonth
	CPulMonthDb&		operator--(int i);					// CPulMonth--
	long				operator-(const CPulMonthDb& month);// CPulMonth - CPulMonth
	BOOL				IsValid();	
	CString				SetCentury();
	CPulMonthDb&		SetMonth(CString Month);
	CPulMonthDb&		SetThisMonth();
	CPulMonthDb&		AddYear(int wYears);
	CPulMonthDb&		AddMonth(int wMonths);
	int					GetNrDays();						// antal dagar i en mnad
	BOOL				DateInMonth(const CPulDateDb &date);

	// Operatorverlagring
	operator			CString()	{ return GetMonth(); }	// tillter typkonvertering frn CPulMonth till CString
	operator			CPulDate()	{ return CPulDate(m_dwMonth.Year, m_dwMonth.Month, m_dwMonth.Day);	};
};

class CPulMonth : public CPulMonthDb
{
public :
	CPulMonth()				{ Init(); }
	CPulMonth(CPulDateDb &d)	{ m_dwMonth = d.m_dwDate; m_dwMonth.Day = 1;}
//	CPulMonth(CPulDate &d)	{ m_dwMonth = d.m_dwDate; m_dwMonth.Day = 1;}

public:
	// Medlemsfunktioner
	CPulMonth&			operator=(const CPulMonth Month);		// CPulMonth = CPulMonth
	CPulMonth&			operator=(const CString Month);			// CPulMonth = CString
	CPulMonth&			operator=(LPCSTR lpszMonth);			// CPulMonth = char *
};




#endif
