/*
 *	Filnamn:		CustomCtrl.h
 *	Syfte  :		Egendefinierade kontroller.specifika fr magna cura
 *					Alla kontroller mste registreras innan anvndning, vilket 
 *					grs med funktionen RegisterControlClass fr respektive 
 *					kontroll.
 */
#ifndef	DEF_CUSTOMCTRL
#define	DEF_CUSTOMCTRL

#include <afxdtctl.h>
#include "PulCustomCtrl.h"



/////////////////////////////////////////////////////////////////////////////
// CKodPopupButton window

class CKodPopupButton : public CBitmapButton
{
private:
	CEdit		*m_pEdit;

// Construction
public:
	CKodPopupButton(CEdit *pEdit)	{ m_pEdit = pEdit; }

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CKodPopupButton)
	//}}AFX_VIRTUAL

// Implementation
public:
//	virtual ~CKodPopupButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(CKodPopupButton)
	afx_msg void OnClicked()	{ m_pEdit->SendMessage(AM_KODPOPUP); }
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CDatumCtrl window
//
//	Denna kontroll hanterar ett datum-flt med kalender
//	
//
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
class CDatumCtrl : public CEdit, public CCustomCtrl
{
// Construction
public:
	CDatumCtrl();
	static	BOOL	RegisterControlClass();										//	Obligatorisk

// Attributes
public:
	CKodPopupButton	*m_pButton;
	BOOL			m_bKillFocus;
	BOOL			m_bPopupButtonPressed;
	BOOL			m_bVal;
	bool			m_bCPulDate2;

// Operations
public:
	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDateDb		*pDocValue,				//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue,			//	Pekare till CString (View-variabel)
									    CPulDate2		*pDocValue,				//	Pekare till (Doc-variabel)
										WORD			wType=0,
										LPCSTR			lpszInitStr=NULL);		//	Initieringsstrng eller NULL om ingen

	void			InitAndDataExchange(CDataExchange	*pDX, 
									    WORD			wCtrlID,				//	Controle ID
									    WORD			wRange,					//	Max tecken eller 0 om ingen grns
									    CString			*pViewValue);			//	Pekare till CString (View-variabel)

// Overrides
	virtual	BOOL	Validate();
	virtual	void	Format();
	virtual	int		GetFieldValue(CPulDateDb *pDest);
	virtual	int		GetFieldValue(CPulDate2 *pDest);
	virtual	int		GetFieldValue(LPSTR lpszDest);
	virtual	void	FocusCtrl()		{ SetFocus(); }
	virtual void	MoveWindow(LPCRECT lpRect, BOOL bRepaint = TRUE);	//	Flyttar kontrollen enligt lpRect.

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDatumCtrl)
	protected:
	virtual void	PostNcDestroy()	{ delete this; }							//	Obligatirisk
	//}}AFX_VIRTUAL
	static	LRESULT CALLBACK EXPORT	WndProcHook(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);	// Obligatirks
	static	WNDPROC					lpfnWndProc;								// Obligatorisk


// Implementation
public:
	virtual ~CDatumCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CDatumCtrl)
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnChange();
	afx_msg void OnKillfocus();
	afx_msg void OnSetfocus();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEnable(BOOL bEnable);
	afx_msg void OnShowWindow(BOOL bShow, UINT nStatus);
	//}}AFX_MSG
	LONG			OnEmpty(UINT wParam, LONG lParam);
	LONG			OnDocToView(UINT wParam, LONG lParam);
	LONG			OnViewToDoc(UINT wParam, LONG lParam);
	LONG			OnValidate(UINT wParam, LONG lParam);
	LONG			OnCheckUpdateState(UINT wParam, LONG lParam);
	LONG			OnKalenderPopup(UINT wParam, LONG lParam);
	LONG			OnFieldLostFocus(UINT wParam, LONG lParam);
	LONG			OnPopupButtonPressed(UINT wParam, LONG lParam);
	LONG			OnDoNotValidate(UINT wParam, LONG lParam);

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CKalenderPopupDlg dialog

class CKalenderPopupDlg : public CDialog
{
// Construction
public:
	CKalenderPopupDlg(CString *pDate, BOOL *pbOK, int x, int y, CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CKalenderPopupDlg)
	enum { IDD = MC_IDD_KALENDERPOPUP };
	CMonthCalCtrl	m_Cal;
	//}}AFX_DATA

	CString	*m_pDate;
	BOOL	*m_pbOK;
	BOOL	m_bFirstTime;
	int		m_x;
	int		m_y;
	BOOL	m_bOk;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CKalenderPopupDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CKalenderPopupDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelectDay(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnGetdaystateKalender(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	afx_msg void OnWindowPosChanging(WINDOWPOS* lpwndpos);
	DECLARE_MESSAGE_MAP()
};

#endif

