/**************************************************************************************************
 * Copyright (c) 2014 TTControl. All rights reserved. Confidential proprietary
 * Schoenbrunnerstrasse 7, A-1040 Wien, Austria. office@ttcontrol.com
 *************************************************************************************************/
/**********************************************************************************************//**
 * \file ptypes_apdb.h
 *
 * \latexonly \hypertarget{ptypes_apdb}{} \endlatexonly
 *
 * \brief APDB target abstraction
 *
 *   This file defines the interface between the generic APDB format and the platform specific
 *   includes and definitions.
 *
 *************************************************************************************************/

#ifndef PTYPES_APDB_H_
#define PTYPES_APDB_H_

/**************************************************************************************************
 *
 * I N C L U D E S
 *
 *************************************************************************************************/

#include <cstdint>

/**************************************************************************************************
 *
 * D E F I N I T I O N S
 *
 *************************************************************************************************/

/****************************************** Data Types *******************************************/

typedef uint8_t             ubyte1; /**< @brief unsigned  8bit integer */
typedef uint16_t            ubyte2; /**< @brief unsigned 16bit integer */
typedef uint32_t            ubyte4; /**< @brief unsigned 32bit integer */
typedef uint64_t            ubyte8; /**< @brief unsigned 64bit integer */

typedef int8_t              sbyte1; /**< @brief signed  8bit integer */
typedef int16_t             sbyte2; /**< @brief signed 16bit integer */
typedef int32_t             sbyte4; /**< @brief signed 32bit integer */
typedef int64_t             sbyte8; /**< @brief signed 64bit integer */

/************************************** Common Definitions ***************************************/

/** @def UBYTE4_MAX_VALUE
 *  @brief maximum value of the ubyte4 type
 */
#define UBYTE4_MAX_VALUE        ((ubyte4)0xFFFFFFFFU)

/** @def UBYTE4_MIN_VALUE
 *  @brief minimum value of the ubyte4 type
 */
#define UBYTE4_MIN_VALUE        ((ubyte4)0x00000000U)

/** @def UBYTE2_MAX_VALUE
 *  @brief maximum value of the ubyte2 type
 */
#define UBYTE2_MAX_VALUE        ((ubyte2)0xFFFFU)

/** @def UBYTE2_MIN_VALUE
 *  @brief minimum value of the ubyte2 type
 */
#define UBYTE2_MIN_VALUE        ((ubyte2)0x0000U)

/** @def UBYTE1_MAX_VALUE
 *  @brief maximum value of the ubyte1 type
 */
#define UBYTE1_MAX_VALUE        ((ubyte1)0xFFU)

/** @def UBYTE1_MIN_VALUE
 *  @brief minimum value of the ubyte1 type
 */
#define UBYTE1_MIN_VALUE        ((ubyte1)0x00U)

#endif /* PTYPES_APDB_H_ */
