/**************************************************************************************************
 * Copyright (c) 2014 TTControl. All rights reserved. Confidential proprietary
 * Schoenbrunnerstrasse 7, A-1040 Wien, Austria. office@ttcontrol.com
 *************************************************************************************************/
/**********************************************************************************************//**
 * \file FIDB.h
 *
 * \latexonly \hypertarget{FIDB}{} \endlatexonly
 *
 * \brief FPGA IP Descriptor Block (FIDB)
 *
 *  Contains the definition for the FPGA IP descriptor block.
 *
 *  The FPGA IP descriptor block contains information about the FPGA IP. Note that the 
 *  FPGA IP descriptor block cannot be modified.
 *
 *************************************************************************************************/

#ifndef FIDB_H_
#define FIDB_H_

/**************************************************************************************************
 *
 * I N C L U D E S
 *
 *************************************************************************************************/

#include "APDB.h"
#include "AuthenticationBlock.h"

/**************************************************************************************************
 *
 * D E F I N I T I O N S
 *
 *************************************************************************************************/
 
/* FIDB version */
#define FIDB_VERSION                0x00000100UL    /**< Current FIDB version is version 1.0.    */

/* Authentication block offset */
#define FIDB_AUTH_OFFSET            88U             /**< The authentication block's offset in
                                                     *   bytes.
                                                     *                                           */

/**************************************************************************************************
 *
 * D A T A   S T R U C T U R E S
 *
 *************************************************************************************************/

/**
 *
 * \brief FIDB structure
 *
 *  Data structure for accessing the Bootloader Descriptor Block.
 *
 */
typedef struct FIDB_t
{
    ubyte4 FIDBVersion;                     /**< The FIDB version:
                                             *      - bit 0-7  ... minor number
                                             *      - bit 8-15 ... major number
                                             *                                                   */
    ubyte4 NodeType;                        /**< The node's hardware type.                       */
    ubyte4 NodeVariant;                     /**< The node's hardware variant.                    */
    ubyte4 NodeVersion;                     /**< The node's hardware revision
                                             *      - bit  0-15 ... minor number
                                             *      - bit 15-31 ... major number
                                             *                                                   */
    ubyte4 FPGAVersion;                     /**< The FPGA IP version:
                                             *      - bit  0- 8 ... patch level
                                             *      - bit  8-15 ... minor number
                                             *      - bit 16-31 ... major number
                                             *                                                   */
    ubyte2 FPGARevision0;                   /**< FPGA revision number 0.                         */
    ubyte2 FPGARevision1;                   /**< FPGA revision number 1.                         */
    ubyte2 FPGARevision2;                   /**< FPGA revision number 2.                         */
    ubyte1 Reserved[62];                    /**< Reserved for future use.                        */
    AUTH_BLOCK_T authentication_block;      /**< The authentication block.                       */
} FIDB_T;

#endif /* FIDB_H_ */
