/**************************************************************************************************
 * Copyright (c) 2014 TTControl. All rights reserved. Confidential proprietary
 * Schoenbrunnerstrasse 7, A-1040 Wien, Austria. office@ttcontrol.com
 *************************************************************************************************/
/**********************************************************************************************//**
 * \file BLDB.h
 *
 * \latexonly \hypertarget{BLDB}{} \endlatexonly
 *
 * \brief Bootloader Descriptor Block (BLDB)
 *
 *  Contains the definition for the bootloader descriptor block.
 *
 *  The bootloader descriptor block contains information about the bootloader and the 
 *  target. Note that the bootloader descriptor block cannot be modified.
 *
 *************************************************************************************************/

#ifndef BLDB_H_
#define BLDB_H_

/**************************************************************************************************
 *
 * I N C L U D E S
 *
 *************************************************************************************************/

#include "APDB.h"
#include "AuthenticationBlock.h"

/**************************************************************************************************
 *
 * D E F I N I T I O N S
 *
 *************************************************************************************************/
 
/* BLDB version */
#define BLDB_VERSION                0x00000100UL    /**< Current BLDB version is version 1.0.    */

/* Authentication block offset */
#define BLDB_AUTH_OFFSET            88U             /**< The authentication block's offset in
                                                     *   bytes.
                                                     *                                           */

/**
 * \name BLDB flags
 * \anchor bldb_flags
 *
 * Defined BLDB flags.
 */
/*@{*/
#define BLDB_FLAG_TYPE              0x00000001UL    /**< Indicates the bootloader type:
                                                     *      - 0 ... first stage bootloader
                                                     *      - 1 ... second stage bootloader
                                                     *                                           */
#define BLDB_FLAG_RESERVED_1        0x00000002UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_2        0x00000004UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_3        0x00000008UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_4        0x00000010UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_5        0x00000020UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_6        0x00000040UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_7        0x00000080UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_8        0x00000100UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_9        0x00000200UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_10       0x00000400UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_11       0x00000800UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_12       0x00001000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_13       0x00002000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_14       0x00004000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_15       0x00008000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_16       0x00010000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_17       0x00020000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_18       0x00040000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_19       0x00080000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_20       0x00100000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_21       0x00200000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_22       0x00400000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_23       0x00800000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_24       0x01000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_25       0x02000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_26       0x04000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_27       0x08000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_28       0x10000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_29       0x20000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_30       0x40000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_31       0x80000000UL    /**< Reserved for future use.                */
/*@}*/

/**************************************************************************************************
 *
 * D A T A   S T R U C T U R E S
 *
 *************************************************************************************************/

/**
 *
 * \brief BLDB structure
 *
 *  Data structure for accessing the Bootloader Descriptor Block.
 *
 */
typedef struct bldb_t
{
    ubyte4 NodeType;                        /**< The node's hardware type.                       */
    ubyte4 NodeVariant;                     /**< The node's hardware variant.                    */
    ubyte4 NodeVersion;                     /**< The node's hardware revision
                                             *      - bit  0-15 ... minor number
                                             *      - bit 15-31 ... major number
                                             *                                                   */
    ubyte4 BootloaderVersion;               /**< The bootloader version:
                                             *      - bit 0-7  ... minor number
                                             *      - bit 8-15 ... major number
                                             *                                                   */
    BL_T_CAN_ID CANDownloadID;              /**< The CAN identifier used for download direction
                                             *   (TTC-Downloader -> target).
                                             *                                                   */
    BL_T_CAN_ID CANUploadID;                /**< The CAN identifier used for upload direction
                                             *   (target -> TTC-Downloader).
                                             *                                                   */
    ubyte4 CANBaudrate;                     /**< Baud rate in kbit/s used for CAN communication. */
    ubyte4 CANChannel;                      /**< The channel used for CAN communication.         */
    ubyte4 BootloaderVersionPatchlevel;     /**< Patchlevel of the bootloader version.           */
    ubyte1 TargetIPAddress[4];              /**< Target IP address for Ethernet download
                                             *   (most significant byte first).
                                             *                                                   */
    ubyte1 SubnetMask[4];                   /**< Subnet mask for Ethernet download
                                             *   (most significant byte first).
                                             *                                                   */
    ubyte1 DLMulticastIPAddress[4];         /**< Multicast IP address of the TTC-Downloader
                                             *   (mostsignificant byte first).
                                             *                                                   */
    ubyte1 Reserved[24];                    /**< Reserved for future use. */
    ubyte4 Flags;                           /**< Flags (see \ref bldb_flags "BLDB flags").       */
    ubyte4 BLDBVersion;                     /**< The BLDB version:
                                             *      - bit 0-7  ... minor number
                                             *      - bit 8-15 ... major number
                                             *                                                   */
    AUTH_BLOCK_T authentication_block;      /**< The authentication block.                       */
} BLDB_T;

#endif /* BLDB_H_ */
