/**************************************************************************************************
 * Copyright (c) 2014 TTControl. All rights reserved. Confidential proprietary
 * Schoenbrunnerstrasse 7, A-1040 Wien, Austria. office@ttcontrol.com
 *************************************************************************************************/
/**********************************************************************************************//**
 * \file AuthenticationBlock.h
 *
 * \latexonly \hypertarget{Authentication Block}{} \endlatexonly
 *
 * \brief Authentication Block
 *
 *  Contains the authentication data for the bootloader and FPGA IP descriptor blocks.
 *
 *  The authentication block contains authentication data for the bootloader and FPGA IP
 *  descriptor blocks.
 *
 *************************************************************************************************/

#ifndef AUTHENTICATION_BLOCK_H_
#define AUTHENTICATION_BLOCK_H_

/**************************************************************************************************
 *
 * I N C L U D E S
 *
 *************************************************************************************************/

#include "APDB.h"

/**************************************************************************************************
 *
 * D E F I N I T I O N S
 *
 *************************************************************************************************/
 
/* Authentication block version */
#define AUTH_VERSION                0x00000100UL    /**< Current authentication block version is
                                                     *   version 1.0.
                                                     *                                           */

/* Authentication block size */
#define AUTH_SIZE                   40U             /**< The authentication block's size in
                                                     *   bytes.
                                                     *                                           */

/**
 * \name Authentication block flags
 * \anchor auth_flags
 *
 * Defined authentication block flags.
 */
/*@{*/
#define BLDB_FLAG_RESERVED_0        0x00000001UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_1        0x00000002UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_2        0x00000004UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_3        0x00000008UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_4        0x00000010UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_5        0x00000020UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_6        0x00000040UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_7        0x00000080UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_8        0x00000100UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_9        0x00000200UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_10       0x00000400UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_11       0x00000800UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_12       0x00001000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_13       0x00002000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_14       0x00004000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_15       0x00008000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_16       0x00010000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_17       0x00020000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_18       0x00040000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_19       0x00080000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_20       0x00100000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_21       0x00200000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_22       0x00400000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_23       0x00800000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_24       0x01000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_25       0x02000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_26       0x04000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_27       0x08000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_28       0x10000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_29       0x20000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_30       0x40000000UL    /**< Reserved for future use.                */
#define BLDB_FLAG_RESERVED_31       0x80000000UL    /**< Reserved for future use.                */
/*@}*/

/**************************************************************************************************
 *
 * D A T A   S T R U C T U R E S
 *
 *************************************************************************************************/

/**
 *
 * \brief Authentication block structure
 *
 *  Data structure for authenticating bootloader and FPGA IP descriptor blocks.
 *
 */
typedef struct auth_block_t
{
    ubyte4 Flags;                           /**< Flags (see 
                                             *   \ref auth_flags "Authentication block flags").
                                             *                                                   */
    ubyte4 StartAddress;                    /**< Start address of the protected assembly.        */
    ubyte4 CodeSectionStart;                /**< Code section start address.                     */
    ubyte4 CodeSectionSize;                 /**< Code section size in bytes.                     */
    ubyte4 CodeSectionCRC;                  /**< CRC-32 calculated over the entire code section. */
    ubyte1 Reserved[16];                    /**< Reserved for future use.                        */
    ubyte4 CRC;                             /**< CRC-32 calculated over the entire descriptor
                                             *   block.
                                             *                                                   */    
} AUTH_BLOCK_T;

#endif /* AUTHENTICATION_BLOCK_H_ */
